/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.utils;

import java.util.Collection;
import org.nfctools.ndef.NdefListener;
import org.nfctools.ndef.NdefOperations;
import org.nfctools.ndef.NdefOperationsListener;
import org.nfctools.ndef.Record;
import org.nfctools.snep.Sneplet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingNdefListener
implements NdefListener,
NdefOperationsListener,
Sneplet {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public void onNdefMessages(Collection<Record> records) {
        for (Record record : records) {
            this.log.info(record.toString());
        }
    }

    @Override
    public void onNdefOperations(NdefOperations ndefOperations) {
        if (ndefOperations.isFormatted()) {
            if (ndefOperations.hasNdefMessage()) {
                this.onNdefMessages(ndefOperations.readNdefMessage());
            } else {
                this.log.info("Empty formatted tag. Size: " + ndefOperations.getMaxSize() + " bytes");
            }
        } else {
            this.log.info("Empty tag. NOT formatted. Size: " + ndefOperations.getMaxSize() + " bytes");
        }
    }

    @Override
    public Collection<Record> doGet(Collection<Record> requestRecords) {
        this.log.info("SNEP get");
        this.onNdefMessages(requestRecords);
        return null;
    }

    @Override
    public void doPut(Collection<Record> requestRecords) {
        this.log.info("SNEP put");
        this.onNdefMessages(requestRecords);
    }
}

