/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.tags;

import java.io.OutputStream;
import org.nfctools.ndef.NotEnoughMemoryException;

public class TagOutputStream
extends OutputStream {
    private byte[] buffer;
    private int count;

    public TagOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buffer = new byte[size];
    }

    public int getRemainingSize() {
        return this.buffer.length - this.count;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public void write(int b) {
        if (this.getRemainingSize() > 0) {
            this.buffer[this.count] = (byte)b;
            ++this.count;
        } else {
            throw new NotEnoughMemoryException();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.getRemainingSize() >= len) {
            System.arraycopy(b, off, this.buffer, this.count, len);
            this.count += len;
        } else {
            throw new NotEnoughMemoryException();
        }
    }
}

