/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.tags;

import java.io.IOException;
import java.io.InputStream;
import org.nfctools.NfcException;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.ul.MemoryLayout;
import org.nfctools.mf.ul.MfUlReaderWriter;

public class TagInputStream
extends InputStream {
    private MemoryLayout memoryLayout;
    private MfUlReaderWriter readerWriter;
    private byte[] currentBlock;
    private int currentPage;
    private int currentByte;

    public TagInputStream(MemoryLayout memoryLayout, MfUlReaderWriter readerWriter) {
        this.memoryLayout = memoryLayout;
        this.readerWriter = readerWriter;
        this.currentPage = memoryLayout.getFirstDataPage();
    }

    private void readNextBlock() {
        try {
            MfBlock[] blocks = this.readerWriter.readBlock(this.currentPage, 1);
            this.currentBlock = blocks[0].getData();
            ++this.currentPage;
            this.currentByte = 0;
        }
        catch (IOException e) {
            new NfcException(e);
        }
    }

    @Override
    public int available() throws IOException {
        if (this.currentBlock == null) {
            return this.memoryLayout.getMaxSize();
        }
        return (this.memoryLayout.getLastDataPage() - this.currentPage + 1) * this.memoryLayout.getBytesPerPage() + (this.memoryLayout.getBytesPerPage() - this.currentByte);
    }

    @Override
    public int read() throws IOException {
        if (this.currentBlock == null || this.currentByte >= this.currentBlock.length) {
            if (this.available() > 0) {
                this.readNextBlock();
            } else {
                return -1;
            }
        }
        byte returnByte = this.currentBlock[this.currentByte++];
        return returnByte;
    }
}

