/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama.response;

import java.util.ArrayList;
import org.nfctools.spi.tama.TamaException;
import org.nfctools.spi.tama.TamaUtils;
import org.nfctools.spi.tama.response.DataExchangeResp;
import org.nfctools.spi.tama.response.GetDepDataResp;
import org.nfctools.spi.tama.response.GetFirmwareVersionResp;
import org.nfctools.spi.tama.response.GetGeneralStatusResp;
import org.nfctools.spi.tama.response.InitTamaTargetResp;
import org.nfctools.spi.tama.response.JumpForDepResp;
import org.nfctools.utils.NfcUtils;

public class TamaResponseDecoder {
    public <T> T decodeMessage(byte[] message) throws TamaException {
        if (message[0] == -43) {
            byte[] payload = new byte[message.length - 2];
            System.arraycopy(message, 2, payload, 0, payload.length);
            int responseCode = TamaResponseDecoder.byteAsInt(message[1]);
            switch (responseCode) {
                case 3: {
                    return (T)this.createGetFirmwareVersionResp(payload);
                }
                case 5: {
                    return (T)this.createGetGeneralStatusResp(payload);
                }
                case 65: {
                    return (T)this.createDataExchangeResp(payload);
                }
                case 87: {
                    return (T)this.createJumpForDepResp(payload);
                }
                case 141: {
                    return (T)this.createInitTamaTargetResp(payload);
                }
                case 135: {
                    return (T)this.createGetDepDataResp(payload);
                }
                case 69: 
                case 83: 
                case 85: 
                case 143: 
                case 145: 
                case 147: 
                case 149: {
                    return (T)this.handleStatusCode(payload);
                }
                case 19: 
                case 51: {
                    return (T)Integer.valueOf(0);
                }
            }
            throw new TamaException("unknown response " + responseCode);
        }
        throw new TamaException("Frame identifier (0xD5) expected, got [" + NfcUtils.convertBinToASCII(message) + "]");
    }

    private static int byteAsInt(byte b) {
        return b & 0xFF;
    }

    private Integer handleStatusCode(byte[] payload) throws TamaException {
        int status = TamaResponseDecoder.byteAsInt(payload[0]);
        TamaUtils.handleStatusCode(status);
        return status;
    }

    private DataExchangeResp createDataExchangeResp(byte[] payload) throws TamaException {
        int statusByte = TamaResponseDecoder.byteAsInt(payload[0]);
        this.handleStatusCode(payload);
        if (TamaUtils.isNADPresent(statusByte)) {
            throw new IllegalStateException("NAD in payload not supported yet");
        }
        byte[] data = new byte[payload.length - 1];
        System.arraycopy(payload, 1, data, 0, payload.length - 1);
        return new DataExchangeResp(TamaUtils.isMoreInformation(statusByte), data);
    }

    private JumpForDepResp createJumpForDepResp(byte[] payload) throws TamaException {
        this.handleStatusCode(payload);
        int targetId = TamaResponseDecoder.byteAsInt(payload[1]);
        byte[] nfcId = new byte[10];
        System.arraycopy(payload, 2, nfcId, 0, nfcId.length);
        byte[] generalBytes = new byte[payload.length - 17];
        System.arraycopy(payload, 17, generalBytes, 0, generalBytes.length);
        return new JumpForDepResp(targetId, nfcId, TamaResponseDecoder.byteAsInt(payload[12]), TamaResponseDecoder.byteAsInt(payload[13]), TamaResponseDecoder.byteAsInt(payload[14]), TamaResponseDecoder.byteAsInt(payload[15]), TamaResponseDecoder.byteAsInt(payload[16]), generalBytes);
    }

    private InitTamaTargetResp createInitTamaTargetResp(byte[] payload) {
        int mode = TamaResponseDecoder.byteAsInt(payload[0]);
        byte[] initiatorCommand = new byte[payload.length - 1];
        System.arraycopy(payload, 1, initiatorCommand, 0, payload.length - 1);
        return new InitTamaTargetResp(mode, initiatorCommand);
    }

    private GetDepDataResp createGetDepDataResp(byte[] payload) throws TamaException {
        int statusByte = TamaResponseDecoder.byteAsInt(payload[0]);
        this.handleStatusCode(payload);
        if (TamaUtils.isNADPresent(statusByte)) {
            throw new IllegalStateException("NAD in payload not supported yet");
        }
        byte[] dataIn = new byte[payload.length - 1];
        System.arraycopy(payload, 1, dataIn, 0, payload.length - 1);
        return new GetDepDataResp(TamaUtils.isMoreInformation(statusByte), dataIn);
    }

    private GetFirmwareVersionResp createGetFirmwareVersionResp(byte[] payload) {
        if (payload.length == 2) {
            return new GetFirmwareVersionResp(TamaResponseDecoder.byteAsInt(payload[0]), TamaResponseDecoder.byteAsInt(payload[1]));
        }
        if (payload.length == 4) {
            return new GetFirmwareVersionResp(TamaResponseDecoder.byteAsInt(payload[0]), TamaResponseDecoder.byteAsInt(payload[1]), TamaResponseDecoder.byteAsInt(payload[2]), TamaResponseDecoder.byteAsInt(payload[3]));
        }
        throw new RuntimeException("Cannot handle payload with length: " + payload.length);
    }

    private GetGeneralStatusResp createGetGeneralStatusResp(byte[] payload) {
        int lastError = TamaResponseDecoder.byteAsInt(payload[0]);
        boolean externalRfDetected = payload[1] == 1;
        int numberOfTargets = TamaResponseDecoder.byteAsInt(payload[2]);
        ArrayList<GetGeneralStatusResp.Target> targets = new ArrayList<GetGeneralStatusResp.Target>(2);
        for (int x = 0; x < numberOfTargets; ++x) {
            targets.add(new GetGeneralStatusResp.Target(payload[3 + x * 4], payload[3 + x * 4 + 1], payload[3 + x * 4 + 2], payload[3 + x * 4 + 3]));
        }
        int samStatus = TamaResponseDecoder.byteAsInt(payload[3 + 4 * numberOfTargets]);
        return new GetGeneralStatusResp(lastError, externalRfDetected, numberOfTargets, samStatus, targets);
    }
}

