/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama.response;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetGeneralStatusResp {
    public static final String[] bitRates = new String[]{"106kbps", "212kbps", "424kbps"};
    public static final Map<Byte, String> modulationTypes = new HashMap<Byte, String>();
    private int lastError;
    private boolean externalRfDetected;
    private int numberOfTargets;
    private int samStatus;
    private List<Target> targets = new ArrayList<Target>();

    public GetGeneralStatusResp(int lastError, boolean externalRfDetected, int numberOfTargets, int samStatus, List<Target> targets) {
        this.lastError = lastError;
        this.externalRfDetected = externalRfDetected;
        this.numberOfTargets = numberOfTargets;
        this.samStatus = samStatus;
        this.targets = targets;
    }

    public boolean isExternalRfDetected() {
        return this.externalRfDetected;
    }

    public int getLastError() {
        return this.lastError;
    }

    public int getNumberOfTargets() {
        return this.numberOfTargets;
    }

    public int getSamStatus() {
        return this.samStatus;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LastError: ").append(this.lastError).append(" ");
        sb.append("externalRfDetected: ").append(this.externalRfDetected).append(" ");
        sb.append("NumberOfTargets: ").append(this.numberOfTargets).append(" ");
        for (Target target : this.targets) {
            sb.append("Target: [").append(target.toString()).append("] ");
        }
        sb.append("SamStatus: ").append(this.samStatus);
        return sb.toString();
    }

    static {
        modulationTypes.put((byte)0, "Mifare");
        modulationTypes.put((byte)1, "Active Mode");
        modulationTypes.put((byte)16, "Felica");
    }

    public static class Target {
        private byte logicalNumber;
        private byte bitRateInReception;
        private byte bitRateInTransmission;
        private byte modulationType;

        public Target(byte logicalNumber, byte bitRateInReception, byte bitRateInTransmission, byte modulationType) {
            this.logicalNumber = logicalNumber;
            this.bitRateInReception = bitRateInReception;
            this.bitRateInTransmission = bitRateInTransmission;
            this.modulationType = modulationType;
        }

        public byte getBitRateInReception() {
            return this.bitRateInReception;
        }

        public byte getBitRateInTransmission() {
            return this.bitRateInTransmission;
        }

        public byte getLogicalNumber() {
            return this.logicalNumber;
        }

        public byte getModulationType() {
            return this.modulationType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("LogicalNumber: ").append(this.logicalNumber).append(" ");
            sb.append("BitRateInReception: ").append(bitRates[this.bitRateInReception]).append(" ");
            sb.append("BitRateInTransmission: ").append(bitRates[this.bitRateInTransmission]).append(" ");
            sb.append("ModulationType: ").append(modulationTypes.get(this.modulationType));
            return sb.toString();
        }
    }
}

