/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama.request;

import org.nfctools.spi.tama.TamaException;
import org.nfctools.spi.tama.request.DataExchangeReq;
import org.nfctools.spi.tama.request.DeselectReq;
import org.nfctools.spi.tama.request.GetDepDataReq;
import org.nfctools.spi.tama.request.GetFirmwareVersionReq;
import org.nfctools.spi.tama.request.GetGeneralStatusReq;
import org.nfctools.spi.tama.request.InitTamaTargetReq;
import org.nfctools.spi.tama.request.JumpForDepReq;
import org.nfctools.spi.tama.request.ReleaseReq;
import org.nfctools.spi.tama.request.RfCommunicationReq;
import org.nfctools.spi.tama.request.SelectReq;
import org.nfctools.spi.tama.request.SetDepDataReq;
import org.nfctools.spi.tama.request.SetGeneralBytesReq;
import org.nfctools.spi.tama.request.SetMetaDepDataReq;
import org.nfctools.spi.tama.request.SetParametersReq;
import org.nfctools.spi.tama.request.TgResponseToInitiatorReq;

public class TamaRequestEncoder {
    public <T> byte[] encodeMessage(T request) throws TamaException {
        if (request instanceof DataExchangeReq) {
            return this.inDataExchange((DataExchangeReq)request);
        }
        if (request instanceof JumpForDepReq) {
            return this.inJumpForDep((JumpForDepReq)request);
        }
        if (request instanceof InitTamaTargetReq) {
            return this.tgInitTamaTarget((InitTamaTargetReq)request);
        }
        if (request instanceof GetDepDataReq) {
            return this.tgGetDEPData();
        }
        if (request instanceof SetMetaDepDataReq) {
            return this.tgSetMetaDEPData((SetMetaDepDataReq)request);
        }
        if (request instanceof SetDepDataReq) {
            return this.tgSetDEPData((SetDepDataReq)request);
        }
        if (request instanceof GetFirmwareVersionReq) {
            return this.getFirmwareVersion();
        }
        if (request instanceof GetGeneralStatusReq) {
            return this.getGeneralStatus();
        }
        if (request instanceof DeselectReq) {
            return this.inDeselect((DeselectReq)request);
        }
        if (request instanceof SelectReq) {
            return this.inSelect((SelectReq)request);
        }
        if (request instanceof ReleaseReq) {
            return this.inRelease((ReleaseReq)request);
        }
        if (request instanceof SetParametersReq) {
            return this.setParameters((SetParametersReq)request);
        }
        if (request instanceof SetGeneralBytesReq) {
            return this.tgSetGeneralBytes((SetGeneralBytesReq)request);
        }
        if (request instanceof RfCommunicationReq) {
            return this.rfCommunication((RfCommunicationReq)request);
        }
        if (request instanceof TgResponseToInitiatorReq) {
            return this.tgResponseToInitiator((TgResponseToInitiatorReq)request);
        }
        throw new TamaException("Unknown request object: " + request.getClass().getName());
    }

    private byte[] inDataExchange(DataExchangeReq request) {
        byte[] buffer = new byte[3 + request.getLength()];
        buffer[0] = -44;
        buffer[1] = 64;
        buffer[2] = (byte)request.getTargetId();
        if (request.isMoreInformation()) {
            buffer[2] = (byte)(buffer[2] | 0x40);
        }
        System.arraycopy(request.getDataOut(), request.getOffset(), buffer, 3, request.getLength());
        return buffer;
    }

    private byte[] inJumpForDep(JumpForDepReq request) {
        if (!request.isActive() && request.getPassiveInitiatorData() == null || request.getPassiveInitiatorData().length != 5) {
            throw new IllegalArgumentException("must set passive initiator data in passive mode");
        }
        byte[] buffer = new byte[5 + (request.getPassiveInitiatorData() == null ? 0 : request.getPassiveInitiatorData().length) + (request.getNfcId3i() == null ? 0 : request.getNfcId3i().length) + (request.getGeneralBytes() == null ? 0 : request.getGeneralBytes().length)];
        buffer[0] = -44;
        buffer[1] = 86;
        buffer[2] = (byte)(request.isActive() ? 1 : 0);
        buffer[3] = request.getBautRate();
        buffer[4] = (byte)((request.getPassiveInitiatorData() == null ? 0 : 1) | (request.getNfcId3i() == null ? 0 : 2) | (request.getGeneralBytes() == null ? 0 : 4));
        int bufPos = 5;
        if (request.getPassiveInitiatorData() != null) {
            System.arraycopy(request.getPassiveInitiatorData(), 0, buffer, bufPos, request.getPassiveInitiatorData().length);
            bufPos += request.getPassiveInitiatorData().length;
        }
        if (request.getNfcId3i() != null) {
            System.arraycopy(request.getNfcId3i(), 0, buffer, bufPos, request.getNfcId3i().length);
            bufPos += request.getNfcId3i().length;
        }
        if (request.getGeneralBytes() != null) {
            System.arraycopy(request.getGeneralBytes(), 0, buffer, bufPos, request.getGeneralBytes().length);
            bufPos += request.getGeneralBytes().length;
        }
        return buffer;
    }

    private byte[] tgInitTamaTarget(InitTamaTargetReq request) {
        byte[] buffer = new byte[39 + (request.getGeneralBytes() == null ? 0 : request.getGeneralBytes().length)];
        buffer[0] = -44;
        buffer[1] = -116;
        buffer[2] = (byte)((request.isDepOnly() ? 2 : 0) | (request.isPassiveOnly() ? 1 : 0));
        int bufPos = 3;
        System.arraycopy(request.getMifareParams(), 0, buffer, bufPos, request.getMifareParams().length);
        System.arraycopy(request.getFelicaParams(), 0, buffer, bufPos += request.getMifareParams().length, request.getFelicaParams().length);
        System.arraycopy(request.getNfcId3t(), 0, buffer, bufPos += request.getFelicaParams().length, request.getNfcId3t().length);
        bufPos += request.getNfcId3t().length;
        if (request.getGeneralBytes() != null) {
            buffer[bufPos++] = (byte)request.getGeneralBytes().length;
            System.arraycopy(request.getGeneralBytes(), 0, buffer, bufPos, request.getGeneralBytes().length);
            bufPos += request.getGeneralBytes().length;
        } else {
            buffer[bufPos++] = 0;
        }
        buffer[bufPos] = 0;
        return buffer;
    }

    private byte[] tgGetDEPData() {
        return new byte[]{-44, -122};
    }

    private byte[] getFirmwareVersion() {
        return new byte[]{-44, 2};
    }

    private byte[] getGeneralStatus() {
        return new byte[]{-44, 4};
    }

    private byte[] tgSetDEPData(SetDepDataReq request) {
        byte[] buffer = new byte[2 + request.getLength()];
        buffer[0] = -44;
        buffer[1] = -114;
        System.arraycopy(request.getDataOut(), request.getOffset(), buffer, 2, request.getLength());
        return buffer;
    }

    private byte[] tgSetMetaDEPData(SetMetaDepDataReq request) {
        byte[] buffer = new byte[2 + request.getLength()];
        buffer[0] = -44;
        buffer[1] = -108;
        System.arraycopy(request.getDataOut(), request.getOffset(), buffer, 2, request.getLength());
        return buffer;
    }

    private byte[] tgResponseToInitiator(TgResponseToInitiatorReq request) {
        byte[] buffer = new byte[2 + request.getLength()];
        buffer[0] = -44;
        buffer[1] = -112;
        System.arraycopy(request.getDataOut(), request.getOffset(), buffer, 2, request.getLength());
        return buffer;
    }

    private byte[] inDeselect(DeselectReq request) {
        return new byte[]{-44, 68, (byte)request.getTargetId()};
    }

    private byte[] inRelease(ReleaseReq request) {
        return new byte[]{-44, 82, (byte)request.getTargetId()};
    }

    private byte[] inSelect(SelectReq request) {
        return new byte[]{-44, 84, (byte)request.getTargetId()};
    }

    private byte[] setParameters(SetParametersReq request) {
        return new byte[]{-44, 18, request.getFlags()};
    }

    private byte[] tgSetGeneralBytes(SetGeneralBytesReq request) {
        byte[] buffer = new byte[2 + request.getGeneralBytes().length];
        buffer[0] = -44;
        buffer[1] = -110;
        System.arraycopy(request.getGeneralBytes(), 0, buffer, 2, request.getGeneralBytes().length);
        return buffer;
    }

    private byte[] rfCommunication(RfCommunicationReq request) {
        byte[] buffer = new byte[3 + request.getConfigData().length];
        buffer[0] = -44;
        buffer[1] = 50;
        buffer[2] = (byte)request.getConfigItem();
        System.arraycopy(request.getConfigData(), 0, buffer, 3, request.getConfigData().length);
        return buffer;
    }
}

