/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama.request;

import org.nfctools.spi.tama.TamaConstants;

public class InitTamaTargetReq {
    private boolean depOnly;
    private boolean passiveOnly;
    private byte[] mifareParams;
    private byte[] felicaParams;
    private byte[] nfcId3t;
    private byte[] generalBytes;

    public InitTamaTargetReq(boolean depOnly, boolean passiveOnly, byte[] mifareParams, byte[] felicaParams, byte[] nfcId3t, byte[] generalBytes) {
        if (mifareParams == null || mifareParams.length != TamaConstants.MIFARE_PARAM_LENGTH) {
            throw new IllegalArgumentException("Mifare Params null or wrong length (should be 6)");
        }
        if (felicaParams == null || felicaParams.length != TamaConstants.FELICA_PARAM_LENGTH) {
            throw new IllegalArgumentException("Felica Params null or wrong length (should be 18)");
        }
        if (nfcId3t == null || nfcId3t.length != TamaConstants.NFCID_PARAM_LENGTH) {
            throw new IllegalArgumentException("nfcId3t Params null or wrong length (should be 10)");
        }
        this.depOnly = depOnly;
        this.passiveOnly = passiveOnly;
        this.mifareParams = mifareParams;
        this.felicaParams = felicaParams;
        this.nfcId3t = nfcId3t;
        this.generalBytes = generalBytes;
    }

    public boolean isDepOnly() {
        return this.depOnly;
    }

    public boolean isPassiveOnly() {
        return this.passiveOnly;
    }

    public byte[] getMifareParams() {
        return this.mifareParams;
    }

    public byte[] getFelicaParams() {
        return this.felicaParams;
    }

    public byte[] getNfcId3t() {
        return this.nfcId3t;
    }

    public byte[] getGeneralBytes() {
        return this.generalBytes;
    }
}

