/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama.nfcip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.nfctools.nfcip.NFCIPCommunicator;
import org.nfctools.spi.tama.nfcip.AbstractNfcIpConnection;
import org.nfctools.spi.tama.nfcip.TamaNfcIpCommunicator;
import org.nfctools.spi.tama.request.GetDepDataReq;
import org.nfctools.spi.tama.request.SetDepDataReq;
import org.nfctools.spi.tama.request.SetMetaDepDataReq;
import org.nfctools.spi.tama.response.GetDepDataResp;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetNfcIpConnection
extends AbstractNfcIpConnection {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private NFCIPCommunicator tamaCommunicator;

    public TargetNfcIpConnection(TamaNfcIpCommunicator tamaCommunicator, byte[] generalBytes) {
        super(2, generalBytes);
        this.tamaCommunicator = tamaCommunicator;
    }

    @Override
    public byte[] receive() throws IOException {
        GetDepDataResp getDepDataResp;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        do {
            getDepDataResp = (GetDepDataResp)this.tamaCommunicator.sendMessage(new GetDepDataReq());
            out.write(getDepDataResp.getDataIn(), 0, getDepDataResp.getDataIn().length);
            this.log.debug("Data received: " + getDepDataResp.getDataIn().length + " More Information: " + getDepDataResp.isMoreInformation());
            this.log.debug("Received data: " + NfcUtils.convertBinToASCII(getDepDataResp.getDataIn()));
        } while (getDepDataResp.isMoreInformation());
        return out.toByteArray();
    }

    @Override
    public void send(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        byte[] sendBuffer = new byte[251];
        this.log.debug("Data to send: " + in.available());
        if (in.available() == 0) {
            this.tamaCommunicator.sendMessage(new SetDepDataReq(sendBuffer, 0, 0));
        } else {
            while (in.available() > 0) {
                int dataRead = in.read(sendBuffer, 0, sendBuffer.length);
                boolean moreInformationToSend = sendBuffer.length == dataRead && in.available() > 0;
                this.log.debug("Sending data... " + dataRead + " more to send: " + moreInformationToSend);
                this.log.debug("Send data: " + NfcUtils.convertBinToASCII(sendBuffer, 0, dataRead));
                if (moreInformationToSend) {
                    this.tamaCommunicator.sendMessage(new SetMetaDepDataReq(sendBuffer, 0, dataRead));
                    continue;
                }
                this.tamaCommunicator.sendMessage(new SetDepDataReq(sendBuffer, 0, dataRead));
            }
        }
    }

    @Override
    public void close() throws IOException {
    }
}

