/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama.nfcip;

import java.io.IOException;
import org.nfctools.NfcContext;
import org.nfctools.api.ConnectionSetup;
import org.nfctools.io.ByteArrayReader;
import org.nfctools.io.ByteArrayWriter;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;
import org.nfctools.nfcip.NFCIPManager;
import org.nfctools.spi.tama.AbstractTamaCommunicator;
import org.nfctools.spi.tama.TamaConstants;
import org.nfctools.spi.tama.nfcip.InitiatorNfcIpConnection;
import org.nfctools.spi.tama.nfcip.TargetNfcIpConnection;
import org.nfctools.spi.tama.request.InitTamaTargetReq;
import org.nfctools.spi.tama.request.JumpForDepReq;
import org.nfctools.spi.tama.request.ReleaseReq;
import org.nfctools.spi.tama.request.RfCommunicationReq;
import org.nfctools.spi.tama.response.InitTamaTargetResp;
import org.nfctools.spi.tama.response.JumpForDepResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamaNfcIpCommunicator
extends AbstractTamaCommunicator
implements NFCIPManager {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private byte[] felicaParams = new byte[TamaConstants.FELICA_PARAM_LENGTH];
    private byte[] mifareParams = new byte[TamaConstants.MIFARE_PARAM_LENGTH];
    private byte[] nfcId = new byte[TamaConstants.NFCID_PARAM_LENGTH];
    private boolean activeInitiator = true;
    private byte baudRateInitiator = (byte)2;
    private boolean depOnlyTarget = false;
    private boolean passiveOnlyTarget = false;
    private byte[] generalBytes;
    private NFCIPConnectionListener connectionListener;
    private Thread waitingThread;

    public TamaNfcIpCommunicator(ByteArrayReader reader, ByteArrayWriter writer) {
        super(reader, writer);
    }

    public void setDepOnlyTarget(boolean depOnlyTarget) {
        this.depOnlyTarget = depOnlyTarget;
    }

    public void setPassiveOnlyTarget(boolean passiveOnlyTarget) {
        this.passiveOnlyTarget = passiveOnlyTarget;
    }

    public void setFelicaParams(byte[] felicaParams) {
        this.felicaParams = felicaParams;
    }

    public void setMifareParams(byte[] mifareParams) {
        this.mifareParams = mifareParams;
    }

    public void setNfcId(byte[] nfcId) {
        this.nfcId = nfcId;
    }

    public void setGeneralBytes(byte[] generalBytes) {
        this.generalBytes = generalBytes;
    }

    public void setConnectionSetup(ConnectionSetup setup) {
        this.setFelicaParams(setup.felicaParams);
        this.setMifareParams(setup.mifareParams);
        this.setNfcId(setup.nfcId3t);
        this.setGeneralBytes(setup.generalBytes);
    }

    @Override
    public NFCIPConnection connectAsInitiator() throws IOException {
        byte[] passiveInitiatorData = new byte[]{0, -1, -1, 0, 0};
        JumpForDepResp jumpForDepResp = (JumpForDepResp)this.sendMessage(new JumpForDepReq(this.activeInitiator, this.baudRateInitiator, passiveInitiatorData, this.nfcId, this.generalBytes));
        return new InitiatorNfcIpConnection(this, jumpForDepResp.getGeneralBytes(), jumpForDepResp.getTargetId());
    }

    public void releaseTargets() throws IOException {
        this.sendMessage(new ReleaseReq(0));
    }

    @Override
    public NFCIPConnection connectAsTarget() throws IOException {
        InitTamaTargetResp initTamaTargetResp = (InitTamaTargetResp)this.sendMessage(new InitTamaTargetReq(this.depOnlyTarget, this.passiveOnlyTarget, this.mifareParams, this.felicaParams, this.nfcId, this.generalBytes));
        byte[] generalBytes = initTamaTargetResp.getInitiatorCommand();
        return new TargetNfcIpConnection(this, generalBytes);
    }

    @Override
    public void setConnectionListener(NFCIPConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public void setTimeout(long millis) {
        this.reader.setTimeout(millis);
    }

    private void initRfTimings() throws IOException {
        byte[] configData = new byte[]{0, 13, 12};
        this.sendMessage(new RfCommunicationReq(2, configData));
    }

    private void initRfRetries() throws IOException {
        byte[] configData = new byte[]{-1, -1, 0};
        this.sendMessage(new RfCommunicationReq(5, configData));
    }

    @Override
    public void initAsTarget() throws IOException {
        this.waitingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!Thread.interrupted()) {
                    try {
                        TamaNfcIpCommunicator.this.setTimeout(-1L);
                        InitTamaTargetResp initTamaTargetResp = (InitTamaTargetResp)TamaNfcIpCommunicator.this.sendMessage(new InitTamaTargetReq(TamaNfcIpCommunicator.this.depOnlyTarget, TamaNfcIpCommunicator.this.passiveOnlyTarget, TamaNfcIpCommunicator.this.mifareParams, TamaNfcIpCommunicator.this.felicaParams, TamaNfcIpCommunicator.this.nfcId, TamaNfcIpCommunicator.this.generalBytes));
                        NfcContext nfcContext = new NfcContext();
                        nfcContext.setAttribute("communicator", TamaNfcIpCommunicator.this);
                        byte[] generalBytes = initTamaTargetResp.getInitiatorCommand();
                        if (TamaNfcIpCommunicator.this.connectionListener != null) {
                            TamaNfcIpCommunicator.this.connectionListener.onConnection(new TargetNfcIpConnection(TamaNfcIpCommunicator.this, generalBytes));
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                        break;
                    }
                }
                TamaNfcIpCommunicator.this.log.info("THREAD DONE");
            }
        });
        this.waitingThread.start();
    }

    public void close() {
        if (this.waitingThread != null && this.waitingThread.isAlive()) {
            this.waitingThread.interrupt();
        }
    }
}

