/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama.nfcip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.nfctools.nfcip.NFCIPCommunicator;
import org.nfctools.spi.tama.nfcip.AbstractNfcIpConnection;
import org.nfctools.spi.tama.request.DataExchangeReq;
import org.nfctools.spi.tama.request.ReleaseReq;
import org.nfctools.spi.tama.response.DataExchangeResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitiatorNfcIpConnection
extends AbstractNfcIpConnection {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private NFCIPCommunicator tamaCommunicator;
    private int targetId;
    private ByteArrayOutputStream response = new ByteArrayOutputStream();

    public InitiatorNfcIpConnection(NFCIPCommunicator tamaCommunicator, byte[] generalBytes, int targetId) {
        super(1, generalBytes);
        this.tamaCommunicator = tamaCommunicator;
        this.targetId = targetId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    @Override
    public byte[] receive() throws IOException {
        byte[] result = this.response.toByteArray();
        this.response.reset();
        return result;
    }

    @Override
    public void send(byte[] data) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        byte[] buffer = new byte[251];
        do {
            int dataRead;
            boolean moreInformationToSend;
            boolean bl = moreInformationToSend = buffer.length == (dataRead = in.read(buffer, 0, buffer.length)) && in.available() > 0;
            if (dataRead < 0) {
                dataRead = 0;
            }
            this.log.debug("Sending data... " + dataRead + " MI: " + moreInformationToSend);
            DataExchangeResp dataExchangeResponse = (DataExchangeResp)this.tamaCommunicator.sendMessage(new DataExchangeReq(this.targetId, moreInformationToSend, buffer, 0, dataRead));
            if (dataExchangeResponse.getDataOut().length <= 0) continue;
            this.response.write(dataExchangeResponse.getDataOut());
        } while (in.available() > 0);
    }

    @Override
    public void close() throws IOException {
        this.tamaCommunicator.sendMessage(new ReleaseReq(this.getTargetId()));
    }
}

