/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama;

import java.io.IOException;
import org.nfctools.io.ByteArrayWriter;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamaWriter
implements ByteArrayWriter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private ByteArrayWriter writer;

    public TamaWriter(ByteArrayWriter writer) {
        this.writer = writer;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        if (data.length > 252) {
            throw new IllegalArgumentException("Message too long. Max 252 bytes. (was: " + data.length + ")");
        }
        byte[] dataToWrite = new byte[7 + data.length];
        dataToWrite[0] = 0;
        dataToWrite[1] = 0;
        dataToWrite[2] = -1;
        dataToWrite[3] = (byte)data.length;
        dataToWrite[4] = -dataToWrite[3];
        System.arraycopy(data, 0, dataToWrite, 5, data.length);
        byte dcs = 0;
        for (int x = 0; x < data.length; ++x) {
            dcs = (byte)(dcs + data[x]);
        }
        dataToWrite[5 + data.length] = -dcs;
        dataToWrite[6 + data.length] = 0;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending frame:  " + NfcUtils.convertBinToASCII(dataToWrite));
        }
        this.writer.write(dataToWrite, 0, dataToWrite.length);
    }
}

