/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama;

import org.nfctools.spi.tama.TamaException;

public class TamaUtils {
    public static void handleStatusCode(int status) throws TamaException {
        if (TamaUtils.isError(status)) {
            throw new TamaException(TamaUtils.getErrorCodeFromStatus(status));
        }
    }

    public static boolean isError(int status) {
        return TamaUtils.getErrorCodeFromStatus(status) != 0;
    }

    public static int getErrorCodeFromStatus(int status) {
        return status & 0x3F;
    }

    public static boolean isMoreInformation(int status) {
        return (status & 0x40) == 64;
    }

    public static boolean isNADPresent(int status) {
        return (status & 0x80) == 128;
    }

    static boolean isACKFrame(byte[] frame, int offset) {
        boolean ackFrame = frame.length + offset >= 6 && frame[offset] == 0 && frame[offset + 1] == 0 && frame[offset + 2] == -1 && frame[offset + 3] == 0 && frame[offset + 4] == -1 && frame[offset + 5] == 0;
        return ackFrame;
    }

    static boolean isErrorFrame(byte[] frame, int offset) {
        return frame.length + offset >= 8 && frame[offset] == 0 && frame[offset + 1] == 0 && frame[offset + 2] == -1 && frame[offset + 3] == 1 && frame[offset + 4] == -1;
    }

    public static byte[] unpackPayload(byte[] message) {
        int length = message[3] & 0xFF;
        byte[] payload = new byte[length];
        System.arraycopy(message, 5, payload, 0, payload.length);
        return payload;
    }
}

