/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama;

import java.io.IOException;
import org.nfctools.NfcTimeoutException;
import org.nfctools.io.ByteArrayReader;
import org.nfctools.spi.tama.TamaException;
import org.nfctools.spi.tama.TamaUtils;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TamaReader
implements ByteArrayReader {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private final ByteArrayReader reader;
    private byte[] buffer = new byte[1024];
    private int bufPos = 0;
    private boolean useDataFrameTimeout = false;
    private long dataFrameTimeout = 0L;

    public TamaReader(ByteArrayReader reader) {
        this.reader = reader;
    }

    @Override
    public void setTimeout(long millis) {
        this.dataFrameTimeout = millis;
        this.useDataFrameTimeout = millis >= 0L;
        this.reader.setTimeout(millis);
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        byte[] response = this.readResponse();
        if (response.length > length - offset) {
            throw new IllegalArgumentException("buffer too small for response, needed " + response.length + " bytes");
        }
        System.arraycopy(response, 0, data, offset, response.length);
        return response.length;
    }

    public byte[] readResponse() throws IOException {
        long timeoutTillFirstAckFrame = 2000L;
        boolean useAckFrameTimeout = true;
        long timeoutCounter = System.currentTimeMillis();
        long timeoutCounterForDataFrame = System.currentTimeMillis();
        do {
            int read;
            if (this.log.isTraceEnabled()) {
                this.log.trace("reading... @" + this.bufPos);
            }
            if ((read = this.reader.read(this.buffer, this.bufPos, this.buffer.length - this.bufPos)) <= 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (read >= 0) {
                this.bufPos += read;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("data read: " + read + "  " + NfcUtils.convertBinToASCII(this.buffer, 0, this.bufPos) + "/" + this.bufPos);
                }
                if (this.bufPos >= 6) {
                    for (int x = 0; x < this.bufPos; ++x) {
                        byte[] resp;
                        if (x + 6 <= this.bufPos && TamaUtils.isACKFrame(this.buffer, x)) {
                            resp = new byte[6];
                            System.arraycopy(this.buffer, x, resp, 0, resp.length);
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("Ack frame:" + NfcUtils.convertBinToASCII(resp));
                            }
                            this.removeFrameFromBuffer(x, resp);
                            useAckFrameTimeout = false;
                            timeoutCounterForDataFrame = System.currentTimeMillis();
                        }
                        if (x + 8 <= this.bufPos && TamaUtils.isErrorFrame(this.buffer, x)) {
                            resp = new byte[8];
                            System.arraycopy(this.buffer, x, resp, 0, resp.length);
                            this.removeFrameFromBuffer(x, resp);
                            int status = TamaUtils.getErrorCodeFromStatus(resp[5]);
                            throw new TamaException(status);
                        }
                        if (x + 5 > this.bufPos) continue;
                        int msgLength = (this.buffer[x + 3] & 0xFF) + 7;
                        if (this.buffer[x] != 0 || this.buffer[x + 1] != 0 || this.buffer[x + 2] != -1 || msgLength + x > this.bufPos || this.buffer[x + 3] != (byte)(-this.buffer[x + 4])) continue;
                        byte[] resp2 = new byte[msgLength];
                        System.arraycopy(this.buffer, x, resp2, 0, msgLength);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Data frame:" + NfcUtils.convertBinToASCII(resp2));
                        }
                        this.removeFrameFromBuffer(x, resp2);
                        return TamaUtils.unpackPayload(resp2);
                    }
                }
            }
            if (!this.useDataFrameTimeout || System.currentTimeMillis() - timeoutCounterForDataFrame <= this.dataFrameTimeout) continue;
            this.resetBuffer();
            throw new NfcTimeoutException();
        } while (!useAckFrameTimeout || System.currentTimeMillis() - timeoutCounter <= timeoutTillFirstAckFrame);
        this.resetBuffer();
        throw new NfcTimeoutException("No complete message within timeout. Msg: [" + NfcUtils.convertBinToASCII(this.buffer, 0, this.bufPos) + "] Length: " + this.bufPos);
    }

    private void resetBuffer() {
        this.bufPos = 0;
    }

    private void removeFrameFromBuffer(int x, byte[] resp) {
        System.arraycopy(this.buffer, x + resp.length, this.buffer, 0, this.bufPos - (resp.length + x));
        this.bufPos -= resp.length + x;
    }
}

