/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TamaException
extends IOException {
    private int errorCode = -1;
    private static final Map<Integer, String> errorMessages = new HashMap<Integer, String>();

    public TamaException(int errorCode) {
        this.errorCode = errorCode;
    }

    public TamaException(String message) {
        super(message);
    }

    @Override
    public String getMessage() {
        String message = errorMessages.get(this.errorCode);
        if (message != null) {
            return "0x" + Integer.toHexString(this.errorCode) + ": " + message;
        }
        if (message == null && this.errorCode != -1) {
            return "Unknown error code: 0x" + Integer.toHexString(this.errorCode);
        }
        return super.getMessage();
    }

    static {
        errorMessages.put(1, "Time out, the target has not answered");
        errorMessages.put(2, "A CRC error has been detected by the contactless UART");
        errorMessages.put(3, "A Parity error has been detected by the contactless UART");
        errorMessages.put(4, "During a MIFARE anticollision/select operation, an erroneoes Bit Count has been detected");
        errorMessages.put(5, "Framing error during MIFARE operation");
        errorMessages.put(6, "An abnormal bit-collision has been detected during bit wise anticollision at 106 kbps");
        errorMessages.put(7, "Communication buffer size insufficient");
        errorMessages.put(9, "RF Buffer overflow has been detected by the contactless UART");
        errorMessages.put(10, "In active communication mode, the RF field has not been switched on in time the counterpart (as definied in NFCIP-1 standard)");
        errorMessages.put(11, "RF Protocol error");
        errorMessages.put(13, "Temperature error");
        errorMessages.put(14, "Internal buffer overflow");
        errorMessages.put(16, "Invalid parameter");
        errorMessages.put(18, "DEP Protocol: unsupported command from the initiator");
        errorMessages.put(19, "DEP Protocol/Mifare/ISO-14443-4: The data format does not match the specification");
        errorMessages.put(20, "Mifare: Authentification error");
        errorMessages.put(36, "ISO 14443-3: UID Check byte wrong");
        errorMessages.put(37, "DEP Protocol: Invalid device state");
        errorMessages.put(38, "Operation not allowed in the configuration");
        errorMessages.put(39, "This command is not acceptable due to the current context of the PN531");
        errorMessages.put(41, "The PN531 configured as a target has been released by its initiator");
    }
}

