/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.tama;

import java.io.IOException;
import org.nfctools.io.ByteArrayReader;
import org.nfctools.io.ByteArrayWriter;
import org.nfctools.nfcip.NFCIPCommunicator;
import org.nfctools.spi.tama.request.GetFirmwareVersionReq;
import org.nfctools.spi.tama.request.GetGeneralStatusReq;
import org.nfctools.spi.tama.request.TamaRequestEncoder;
import org.nfctools.spi.tama.response.GetFirmwareVersionResp;
import org.nfctools.spi.tama.response.GetGeneralStatusResp;
import org.nfctools.spi.tama.response.TamaResponseDecoder;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTamaCommunicator
implements NFCIPCommunicator {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected TamaResponseDecoder responseResolver = new TamaResponseDecoder();
    protected TamaRequestEncoder requestEncoder = new TamaRequestEncoder();
    protected ByteArrayReader reader;
    protected ByteArrayWriter writer;

    protected AbstractTamaCommunicator(ByteArrayReader reader, ByteArrayWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public <RESP, REQ> RESP sendMessage(REQ request) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending message type:  " + request.getClass().getSimpleName());
        }
        byte[] response = this.sendMessageInternal(this.requestEncoder.encodeMessage(request));
        Object resp = this.responseResolver.decodeMessage(response);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Received message type:  " + resp.getClass().getSimpleName());
        }
        return (RESP)resp;
    }

    private byte[] sendMessageInternal(byte[] message) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Sending message:  " + NfcUtils.convertBinToASCII(message));
        }
        this.writer.write(message, 0, message.length);
        byte[] responseBuffer = new byte[1024];
        int responseLength = this.reader.read(responseBuffer, 0, responseBuffer.length);
        byte[] response = new byte[responseLength];
        System.arraycopy(responseBuffer, 0, response, 0, responseLength);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Received message: " + NfcUtils.convertBinToASCII(response));
        }
        return response;
    }

    public void showTamaVersionAndStatus() throws IOException {
        GetFirmwareVersionResp getFirmwareVersionResp = (GetFirmwareVersionResp)this.sendMessage(new GetFirmwareVersionReq());
        this.log.info("Version: " + getFirmwareVersionResp.getVersion() + " Revision: " + getFirmwareVersionResp.getRevision());
        GetGeneralStatusResp getGeneralStatusResp = (GetGeneralStatusResp)this.sendMessage(new GetGeneralStatusReq());
        this.log.info(getGeneralStatusResp.toString());
    }
}

