/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.scm;

import java.io.IOException;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import org.nfctools.api.TagListener;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.scio.AbstractTerminal;
import org.nfctools.scio.TerminalMode;
import org.nfctools.scio.TerminalStatus;
import org.nfctools.spi.scm.Scl3711;
import org.nfctools.spi.scm.Scl3711NfcipManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SclTerminal
extends AbstractTerminal {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Scl3711 scl3711;

    @Override
    public boolean canHandle(String terminalName) {
        return terminalName.contains("SCL3711");
    }

    @Override
    public void registerTagListener(TagListener tagListener) {
    }

    @Override
    public void setMode(TerminalMode terminalMode) {
    }

    @Override
    public void startListening() {
    }

    @Override
    public void stopListening() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initInitiatorDep() throws IOException {
        while (!Thread.interrupted()) {
            try {
                Card card = this.cardTerminal.connect("direct");
                this.scl3711 = new Scl3711(card);
                this.notifyStatus(TerminalStatus.WAITING);
                this.log.info("Waiting...");
                try {
                    Scl3711NfcipManager nfcipManager = new Scl3711NfcipManager(this.scl3711);
                    NFCIPConnection nfcipConnection = nfcipManager.connectAsInitiator();
                    this.handleNfcipConnection(nfcipConnection);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    this.log.info("Disconnect from card");
                    card.disconnect(true);
                    this.notifyStatus(TerminalStatus.DISCONNECTED);
                }
            }
            catch (CardException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void initTargetDep() throws IOException {
        this.log.warn("Target mode not supported yet. Using initiator...");
        this.initInitiatorDep();
    }

    @Override
    protected void handleNfcipConnection(NFCIPConnection nfcipConnection) throws IOException {
        if (nfcipConnection != null && this.nfcipConnectionListener != null) {
            this.notifyStatus(TerminalStatus.CONNECTED);
            this.nfcipConnectionListener.onConnection(nfcipConnection);
        }
    }
}

