/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.scm;

import java.io.IOException;
import org.nfctools.SimpleNfcTarget;
import org.nfctools.llcp.LlcpConstants;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;
import org.nfctools.nfcip.NFCIPManager;
import org.nfctools.spi.scm.ConnectResponse;
import org.nfctools.spi.scm.Scl3711;
import org.nfctools.spi.scm.Scl3711Initiator;
import org.nfctools.spi.scm.TimeoutException;

public class Scl3711NfcipManager
implements NFCIPManager {
    private Scl3711 scl3711;

    public Scl3711NfcipManager(Scl3711 scl3711) {
        this.scl3711 = scl3711;
    }

    @Override
    public NFCIPConnection connectAsTarget() throws IOException {
        throw new IllegalStateException("unsupported operation");
    }

    @Override
    public NFCIPConnection connectAsInitiator() throws IOException {
        while (!Thread.interrupted()) {
            try {
                ConnectResponse connectResponse = this.scl3711.initiatorConnect(LlcpConstants.nfcId3t, LlcpConstants.initiatorGeneralBytes);
                SimpleNfcTarget target = new SimpleNfcTarget(0, connectResponse.getNfcId(), connectResponse.getGeneralBytes());
                return new Scl3711Initiator(this.scl3711, target);
            }
            catch (TimeoutException e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ie) {
                    return null;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.scl3711.disconnect();
            }
        }
        return null;
    }

    @Override
    public void initAsTarget() throws IOException {
        throw new IllegalStateException("unsupported operation");
    }

    @Override
    public void setConnectionListener(NFCIPConnectionListener connectionListener) {
        throw new IllegalStateException("unsupported operation");
    }
}

