/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.scm;

import java.io.IOException;
import org.nfctools.api.Target;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.spi.scm.Scl3711;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scl3711Initiator
implements NFCIPConnection {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Scl3711 scl3711;
    private Target target;
    private byte[] buffer;

    public Scl3711Initiator(Scl3711 scl3711, Target target) {
        this.scl3711 = scl3711;
        this.target = target;
    }

    @Override
    public boolean isTarget() {
        return false;
    }

    @Override
    public boolean isInitiator() {
        return true;
    }

    @Override
    public byte[] receive() throws IOException {
        if (this.buffer.length != 2 && this.buffer[0] != 0 && this.log.isTraceEnabled()) {
            this.log.trace("receive => " + NfcUtils.convertBinToASCII(this.buffer));
        }
        return this.buffer;
    }

    @Override
    public void send(byte[] data) throws IOException {
        if (data.length != 2 && data[0] != 0 && this.log.isTraceEnabled()) {
            this.log.trace("send    => " + NfcUtils.convertBinToASCII(data));
        }
        this.buffer = this.scl3711.transceive(data);
    }

    @Override
    public void close() throws IOException {
        this.scl3711.disconnect();
    }

    @Override
    public byte[] getGeneralBytes() {
        return this.target.getGeneralBytes();
    }
}

