/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.scm;

import java.io.IOException;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import org.nfctools.spi.scm.ConnectResponse;
import org.nfctools.spi.scm.GeneralFailureException;
import org.nfctools.spi.scm.TimeoutException;

public class Scl3711 {
    public static final int IOCTL_GET_CARD_TYPE = 2304;
    public static final int IOCTL_GET_DEVICE_CAPAB = 2305;
    public static final int IOCTL_GET_OR_SET_RW_P2P_MODES = 2310;
    public static final int IOCTL_INITIATOR_POLL = 2306;
    public static final int IOCTL_INITIATOR_CONNECT = 2307;
    public static final int IOCTL_INITIATOR_TRANSCEIVE = 2308;
    public static final int IOCTL_INITIATOR_DISCONNECT = 2309;
    public static final int IOCTL_TARGET_RECEIVE = 2311;
    public static final int IOCTL_TARGET_SEND = 2312;
    private Card card;

    public Scl3711(Card card) {
        this.card = card;
    }

    private int getErrorCodeFromException(Throwable e) {
        if (e == null) {
            return Integer.MIN_VALUE;
        }
        String msg = e.getMessage();
        if (msg.startsWith("Unknown error 0x")) {
            String error = msg.substring("Unknown error 0x".length());
            return Integer.parseInt(error, 16);
        }
        return this.getErrorCodeFromException(e.getCause());
    }

    public byte[] transmit(int ioControl, byte[] command) throws IOException {
        try {
            ioControl = 0x310000 + ioControl * 4;
            return this.card.transmitControlCommand(ioControl, command);
        }
        catch (CardException e) {
            int error = this.getErrorCodeFromException(e);
            switch (error) {
                case 121: {
                    throw new TimeoutException();
                }
                case 31: {
                    throw new GeneralFailureException();
                }
            }
            throw new IOException("Error " + error);
        }
    }

    public ConnectResponse initiatorConnect(byte[] nfcipId, byte[] generalBytes) throws IOException {
        byte[] buffer = new byte[64];
        buffer[0] = 0;
        buffer[1] = 2;
        buffer[2] = 3;
        System.arraycopy(nfcipId, 0, buffer, 3, 10);
        System.arraycopy(generalBytes, 0, buffer, 16, generalBytes.length);
        buffer[13] = 0;
        buffer[14] = 4;
        buffer[15] = (byte)generalBytes.length;
        byte[] result = this.transmit(2307, buffer);
        byte[] nfcIdTarget = new byte[10];
        byte[] generalBytesTarget = new byte[result[16]];
        System.arraycopy(result, 1, nfcIdTarget, 0, 10);
        System.arraycopy(result, 17, generalBytesTarget, 0, generalBytesTarget.length);
        ConnectResponse response = new ConnectResponse(result[15], nfcIdTarget, generalBytesTarget);
        return response;
    }

    public int getCardType() throws IOException {
        byte[] result = this.transmit(2304, new byte[0]);
        return result[0];
    }

    public int getDeviceCapab() throws IOException {
        byte[] result = this.transmit(2305, new byte[0]);
        return (result[0] & 0xFF) << 8 | result[1] & 0xFF;
    }

    public void disconnect() throws IOException {
        this.transmit(2309, new byte[]{1});
    }

    public byte[] transceive(byte[] data) throws IOException {
        return this.transmit(2308, data);
    }
}

