/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.arygon;

import java.io.IOException;
import org.nfctools.mf.MfCardListener;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.card.MfCard;
import org.nfctools.spi.arygon.ArygonHighLevelReaderWriter;
import org.nfctools.spi.arygon.ArygonReaderWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PollingCardScanner
implements Runnable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ArygonHighLevelReaderWriter nfcReaderWriter;
    private MfCardListener cardListener;
    private MfReaderWriter readerWriter;

    public PollingCardScanner(ArygonHighLevelReaderWriter nfcReaderWriter, MfCardListener cardListener, MfReaderWriter readerWriter) {
        this.nfcReaderWriter = nfcReaderWriter;
        this.cardListener = cardListener;
        this.readerWriter = readerWriter;
    }

    @Override
    public void run() {
        this.log.debug("Polling started");
        MfCard card = null;
        while (!Thread.interrupted()) {
            try {
                if (this.nfcReaderWriter.hasData()) {
                    this.log.debug("Reader has data");
                    try {
                        card = ((ArygonReaderWriter)this.readerWriter).readCard();
                        this.cardListener.cardDetected(card, this.readerWriter);
                        this.readerWriter.setCardIntoHalt(card);
                    }
                    catch (IOException e) {
                        try {
                            this.log.trace("Halting card. " + e.getMessage(), e);
                            this.readerWriter.reselectCard(card);
                            this.readerWriter.setCardIntoHalt(card);
                        }
                        catch (Exception e1) {
                            this.log.trace("Halting failed...");
                            Thread.sleep(1000L);
                        }
                    }
                    ((ArygonReaderWriter)this.readerWriter).scanForCard();
                    continue;
                }
                Thread.sleep(10L);
            }
            catch (IOException e) {
                this.log.error(e.getMessage(), e);
                break;
            }
            catch (InterruptedException e) {
                return;
            }
        }
        this.log.debug("DONE " + Thread.currentThread().getName());
    }
}

