/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.arygon;

import java.util.HashMap;
import java.util.Map;
import org.nfctools.spi.arygon.ArygonMessage;
import org.nfctools.utils.NfcUtils;

public class MicroControllerErrorResolver {
    private static final Map<Integer, String> msg = new HashMap<Integer, String>();

    public static String resolveErrorMessage(ArygonMessage arygonMessage) {
        if (arygonMessage.hasErrorCodes()) {
            return "Code: " + arygonMessage.getErrorCode1() + ", " + msg.get(new Integer(arygonMessage.getErrorCode1())) + " [" + new String(NfcUtils.convertBinToASCII(arygonMessage.getHeader())) + "]";
        }
        return "unknown error code";
    }

    static {
        msg.put(0, "OK = no Error.");
        msg.put(1, "Ringbuffer, interrupt write overflow (TAMA side).");
        msg.put(2, "UART1 receiver framing or overrun error (TAMA side).");
        msg.put(3, "UART2 receiver framing or overrun error (host side).");
        msg.put(4, "TAMA receive packet checksum wrong (packet length or packet data).");
        msg.put(5, "Host receive packet checksum wrong (packet length or packet data).");
        msg.put(6, "Unknown mode-select command from host.");
        msg.put(7, "Ringbuffer, interrupt write overflow (host side).");
        msg.put(8, "One or more command parameter are out of range.");
        msg.put(9, "TAMA has detected an error at application level.");
        msg.put(10, "No or wrong TAMA ack received after sending of TAMA command sequences.");
        msg.put(11, "Wrong TAMA set baud rate response received after TAMA set baud rate command.");
        msg.put(12, "Host or TAMA Command packet supervision Timer expired. Packet not complete within 1s.");
        msg.put(13, "Ringbuffer write overflow (host side).");
        msg.put(14, "No or wrong TAMA ack received after \u03bcC sends a command to TAMA.");
        msg.put(15, "Host High level language checksum wrong.");
        msg.put(16, "Current block has no value block format (block format is corrupted).");
        msg.put(17, "Error during increment / decrement / copy value block.");
        msg.put(18, "Baudrate not supported with the current low speed (low power) crystal.");
        msg.put(19, "Internal EEPROM read after write failed.");
        msg.put(20, "Internal EEPROM checksum failed (warning message).");
        msg.put(21, "Internal EEPROM address is out of the allowed range.");
        msg.put(22, "Internal EEPROM login missing. Application has no write access authorization.");
        msg.put(23, "Internal EEPROM login PIN code wrong. Access denied.");
        msg.put(24, "Receive partylinebuffer overflow (from TAMA to \u03bcC).");
        msg.put(25, "Infomessage: No response available (partylinebuffer is empty).");
        msg.put(26, "Optional LCD Busy check supervision Timer expired.");
        msg.put(27, "More than 3 EEPROM login retry with a wrong PIN code.");
        msg.put(45, "Error during Mifare Ultralight C 3DES authentication.");
    }
}

