/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.arygon;

import java.io.IOException;
import org.nfctools.mf.MfAccess;
import org.nfctools.mf.MfCardListener;
import org.nfctools.mf.MfException;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.block.Block;
import org.nfctools.mf.block.BlockResolver;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.card.MfCard;
import org.nfctools.spi.arygon.ArygonHighLevelReaderWriter;
import org.nfctools.spi.arygon.ArygonMessage;
import org.nfctools.spi.arygon.CardResolver;
import org.nfctools.spi.arygon.PollingCardScanner;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArygonReaderWriter
implements MfReaderWriter {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private ArygonHighLevelReaderWriter nfcReaderWriter;
    private Thread pollingThread = null;
    private CardResolver cardResolver = new CardResolver();
    private BlockResolver mfBlockResolver = new BlockResolver();

    public ArygonReaderWriter(ArygonHighLevelReaderWriter nfcReaderWriter) {
        this.nfcReaderWriter = nfcReaderWriter;
    }

    @Override
    public MfBlock[] readBlock(MfAccess mfAccess) throws IOException {
        this.loginIfNotAuthenticated(mfAccess);
        MfBlock[] returnBlocks = new Block[mfAccess.getBlocksToRead()];
        for (int block = 0; block < mfAccess.getBlocksToRead(); ++block) {
            String blockNumber = this.createBlockNumber(mfAccess, block);
            this.nfcReaderWriter.sendMessage(("0r" + blockNumber).getBytes());
            ArygonMessage message = this.nfcReaderWriter.receiveMessage();
            if (message.hasTamaErrorCode()) {
                this.throwException(mfAccess, message, "Cannot read.");
            }
            byte[] rawData = new byte[message.getPayload().length - 4];
            System.arraycopy(message.getPayload(), 4, rawData, 0, message.getPayload().length - 4);
            returnBlocks[block] = BlockResolver.resolveBlock(mfAccess.getCard(), mfAccess.getSector(), block + mfAccess.getBlock(), rawData);
        }
        return returnBlocks;
    }

    private void throwException(MfAccess mfAccess, ArygonMessage message, String exceptionMessage) throws IOException {
        if (message.getTamaErrorCode() == 19) {
            this.reselectCard(mfAccess.getCard());
            throw new MfLoginException("Cannot login.");
        }
        throw new MfException(exceptionMessage + " Sector: " + mfAccess.getSector() + ", Block: " + mfAccess.getBlock() + " Key: " + mfAccess.getKey().name() + ", Tama: " + new String(message.getPayload()) + " TamaCode: " + message.getTamaErrorCode());
    }

    private void loginIfNotAuthenticated(MfAccess mfAccess) throws IOException {
        this.loginIntoSector(mfAccess);
    }

    private void loginIntoSector(MfAccess mfAccess) throws IOException {
        String blockNumber = this.createBlockNumber(mfAccess, 0);
        String loginMessage = "0l" + blockNumber + "ff" + mfAccess.getKey().name() + NfcUtils.convertBinToASCII(mfAccess.getKeyValue());
        this.nfcReaderWriter.sendMessage(loginMessage.getBytes());
        ArygonMessage message = this.nfcReaderWriter.receiveMessage();
        if (message.hasTamaErrorCode()) {
            this.reselectCard(mfAccess.getCard());
            throw new MfLoginException("Login failed. Sector: " + mfAccess.getSector() + ", Block: " + mfAccess.getBlock() + " Key: " + mfAccess.getKey().name() + ", Tama: " + new String(message.getPayload()));
        }
    }

    @Override
    public void writeBlock(MfAccess mfAccess, MfBlock ... mfBlock) throws IOException {
        this.loginIfNotAuthenticated(mfAccess);
        for (int x = 0; x < mfBlock.length; ++x) {
            String blockNumber = this.createBlockNumber(mfAccess, x);
            if (mfAccess.getCard().isTrailerBlock(mfAccess.getSector(), mfAccess.getBlock() + x) && !(mfBlock[x] instanceof TrailerBlock)) {
                throw new MfException("invalid block for trailer");
            }
            this.nfcReaderWriter.sendMessage(("0wb" + blockNumber + NfcUtils.convertBinToASCII(mfBlock[x].getData())).getBytes());
            ArygonMessage message = this.nfcReaderWriter.receiveMessage();
            if (!message.hasTamaErrorCode()) continue;
            this.throwException(mfAccess, message, "Cannot write.");
        }
    }

    private String createBlockNumber(MfAccess mfAccess, int blockOffset) {
        int blockNumber = mfAccess.getCard().getBlockNumber(mfAccess.getSector(), mfAccess.getBlock()) + blockOffset;
        String rb = Integer.toHexString(blockNumber).toUpperCase();
        if (rb.length() == 1) {
            rb = "0" + rb;
        }
        return rb;
    }

    @Override
    public void setCardIntoHalt(MfCard card) throws IOException {
        String targetId = "00";
        this.log.debug("Halting Card " + card.getId() + " / TargetId: " + targetId);
        this.nfcReaderWriter.sendMessage(("0h" + targetId).getBytes());
        ArygonMessage message = this.nfcReaderWriter.receiveMessage();
        if (message.hasTamaErrorCode()) {
            throw new MfException("Cannot send data.");
        }
    }

    public void scanForCard() throws IOException {
        this.nfcReaderWriter.sendMessage("0s".getBytes());
    }

    public MfCard readCard() throws IOException {
        ArygonMessage message = this.nfcReaderWriter.receiveMessage();
        if (message.hasPayload()) {
            byte[] data = NfcUtils.convertHexAsciiToByteArray(message.getPayload());
            byte targetNumber = data[2];
            byte type = data[5];
            byte nfcIdLength = data[6];
            byte[] cardId = new byte[nfcIdLength];
            System.arraycopy(data, 7, cardId, 0, nfcIdLength);
            return this.cardResolver.resolvecard(type, cardId, targetNumber);
        }
        throw new MfException("no card");
    }

    @Override
    public void reselectCard(MfCard card) throws IOException {
        this.scanForCard();
        MfCard newcard = this.readCard();
        if (!NfcUtils.isEqualArray(card.getId(), newcard.getId())) {
            throw new MfException("New card detected. Id does not match. (Expected: " + card + ", got: " + newcard + ")");
        }
    }

    @Override
    public void setCardListener(MfCardListener cardListener) throws IOException {
        this.scanForCard();
        this.pollingThread = new Thread(new PollingCardScanner(this.nfcReaderWriter, cardListener, this));
        this.pollingThread.setDaemon(false);
        this.log.debug("Starting new thread " + this.pollingThread.getName());
        this.pollingThread.start();
    }

    @Override
    public boolean waitForCard(MfCardListener mfCardListener, int timeout) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeCardListener() {
        if (this.pollingThread != null && this.pollingThread.isAlive()) {
            this.pollingThread.interrupt();
        }
    }
}

