/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.arygon;

public class ArygonMessage {
    private byte[] header;
    private byte[] payload;

    public ArygonMessage(byte[] payload) {
        this.payload = payload;
    }

    public ArygonMessage(byte[] header, byte[] payload) {
        this.header = header;
        this.payload = payload;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public boolean hasPayload() {
        return this.payload != null && this.payload.length > 0;
    }

    public boolean hasHeader() {
        return this.header != null && this.header.length > 0;
    }

    public boolean hasErrorCodes() {
        return this.getErrorCode1() != 0 || this.getErrorCode2() != 0;
    }

    public byte getErrorCode1() {
        return this.header[1];
    }

    public byte getErrorCode2() {
        return this.header[2];
    }

    public boolean hasTamaErrorCode() {
        return this.payload.length < 4 || this.payload[2] != 48 || this.payload[3] != 48;
    }

    public byte getTamaErrorCode() {
        String code = new String(this.payload, 2, 2);
        return Integer.valueOf(code, 16).byteValue();
    }
}

