/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.arygon;

import java.io.IOException;
import org.nfctools.io.NfcDevice;
import org.nfctools.spi.arygon.AbstractArygonReaderWriter;
import org.nfctools.spi.arygon.ArygonAsciiReader;
import org.nfctools.spi.arygon.ArygonMessage;
import org.nfctools.spi.arygon.MicroControllerErrorResolver;
import org.nfctools.spi.arygon.MicroControllerException;

public class ArygonHighLevelReaderWriter
extends AbstractArygonReaderWriter {
    private ArygonAsciiReader arygonAsciiReader;
    private int bufferSize;

    public ArygonHighLevelReaderWriter(NfcDevice nfcDevice, int bufferSize) {
        super(nfcDevice);
        this.bufferSize = bufferSize;
    }

    @Override
    public void open() throws IOException {
        super.open();
        this.arygonAsciiReader = new ArygonAsciiReader(this.in, this.bufferSize);
    }

    public void sendMessage(ArygonMessage message) throws IOException {
        this.log.debug(new String(message.getPayload()));
        this.out.write(message.getPayload());
        this.getMicroControllerResponse();
    }

    public ArygonMessage receiveMessage() throws IOException {
        return this.getTamaResponse();
    }

    public String getReaderVersion() throws IOException {
        this.out.write("0av".getBytes());
        return new String(this.getMicroControllerResponse().getPayload());
    }

    public void initLeds() throws IOException {
        for (AbstractArygonReaderWriter.LED led : AbstractArygonReaderWriter.LED.values()) {
            this.sendMessage(("0apc" + led.getId() + "00").getBytes());
        }
    }

    public boolean hasData() throws IOException {
        return this.arygonAsciiReader.hasData();
    }

    public void switchOnLed(AbstractArygonReaderWriter.LED led) throws IOException {
        this.sendMessage(("0apw" + led.getId() + "01").getBytes());
    }

    public void switchOffLed(AbstractArygonReaderWriter.LED led) throws IOException {
        this.sendMessage(("0apw" + led.getId() + "00").getBytes());
    }

    public void sendMessage(byte[] message) throws IOException {
        this.sendMessage(new ArygonMessage(message));
    }

    private ArygonMessage getTamaResponse() throws IOException {
        ArygonMessage message = this.getMicroControllerResponse();
        return message;
    }

    private ArygonMessage getMicroControllerResponse() throws IOException {
        ArygonMessage message = this.arygonAsciiReader.readResponse();
        if (message.hasHeader() && message.hasErrorCodes()) {
            throw new MicroControllerException(MicroControllerErrorResolver.resolveErrorMessage(message));
        }
        return message;
    }
}

