/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.arygon;

import gnu.io.SerialPort;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.nfctools.com.AbstractBaudRateNegotiator;
import org.nfctools.spi.arygon.MicroControllerException;

public class ArygonBaudRateNegotiator
extends AbstractBaudRateNegotiator {
    private static Map<Integer, String> baudRateToArygonCodeMap = new TreeMap<Integer, String>();

    @Override
    public void negotiateBaudRateOnObject(SerialPort port, int baudRate) throws IOException {
        String arygonCode = baudRateToArygonCodeMap.get(baudRate);
        if (arygonCode == null) {
            throw new IllegalArgumentException("baudrate not supported.");
        }
        this.port = port;
        this.in = port.getInputStream();
        this.out = port.getOutputStream();
        this.findoutCurrentBaudRate();
        this.log.debug("Setting baud rate between \u00b5C and TAMA to " + baudRate);
        this.sendMessageAndProcessResponse("0at" + arygonCode);
        this.log.debug("Setting baud rate between host and \u00b5C to " + baudRate);
        this.sendMessageAndProcessResponse("0ah" + arygonCode);
        this.setSerialPortParams(baudRate);
        this.checkPortBaudRate();
        this.clearInputBuffers();
    }

    private void sendMessageAndProcessResponse(String message) throws IOException {
        this.sendASCIIMessage(message);
        String resp = this.readResponse();
        if (!resp.startsWith("FF000000")) {
            throw new MicroControllerException(resp);
        }
        this.log.debug("resp: " + resp);
    }

    @Override
    protected boolean checkPortBaudRate() throws IOException {
        this.log.debug("checking baud rate ...");
        this.sendASCIIMessage("0av");
        String resp = this.readResponse();
        return resp.startsWith("FF0000");
    }

    static {
        baudRateToArygonCodeMap.put(9600, "00");
        baudRateToArygonCodeMap.put(19200, "01");
        baudRateToArygonCodeMap.put(38400, "02");
        baudRateToArygonCodeMap.put(57600, "03");
        baudRateToArygonCodeMap.put(115200, "04");
        baudRateToArygonCodeMap.put(230400, "05");
        baudRateToArygonCodeMap.put(460800, "06");
    }
}

