/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.arygon;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.nfctools.spi.arygon.ArygonMessage;
import org.nfctools.utils.NfcUtils;

public class ArygonAsciiReader {
    private static final long TIMEOUT_IN_MILLIS = 2000L;
    private InputStream in;
    private byte[] buffer;
    private int bufPos = 0;

    public ArygonAsciiReader(InputStream in, int bufferSize) {
        this.in = in;
        this.buffer = new byte[bufferSize];
    }

    public ArygonMessage readResponse() throws IOException {
        long timeoutCounter = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeoutCounter < 2000L) {
            int read = this.in.read(this.buffer, this.bufPos, this.buffer.length - this.bufPos);
            if (read != -1) {
                this.bufPos += read;
                timeoutCounter = System.currentTimeMillis();
            } else {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            if (this.bufPos < 3) continue;
            for (int x = 1; x < this.bufPos; ++x) {
                if (this.buffer[x - 1] != 13 || this.buffer[x] != 10) continue;
                byte[] resp = new byte[x - 1];
                System.arraycopy(this.buffer, 0, resp, 0, x - 1);
                System.arraycopy(this.buffer, x + 1, this.buffer, 0, this.bufPos - (x + 1));
                this.bufPos -= x + 1;
                Arrays.fill(this.buffer, this.bufPos, this.buffer.length - this.bufPos, (byte)0);
                return this.createArygonMessage(resp);
            }
        }
        return new ArygonMessage(new byte[0]);
    }

    private ArygonMessage createArygonMessage(byte[] bytes) throws IOException {
        if (bytes.length >= 8 && bytes[0] == 70 && bytes[1] == 70) {
            byte[] header = NfcUtils.convertHexAsciiToByteArray(bytes, 0, 8);
            byte[] payload = new byte[header[3]];
            try {
                System.arraycopy(bytes, 8, payload, 0, payload.length);
                return new ArygonMessage(header, payload);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new IOException("unparsable message received");
    }

    public boolean hasData() throws IOException {
        return this.in.available() > 0;
    }
}

