/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.nfctools.api.TagType;
import org.nfctools.llcp.LlcpConstants;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.scio.TerminalStatus;
import org.nfctools.spi.acs.AbstractTerminalTagScanner;
import org.nfctools.spi.acs.AcsDirectChannelTag;
import org.nfctools.spi.acs.AcsTagUtils;
import org.nfctools.spi.acs.ApduTagReaderWriter;
import org.nfctools.spi.tama.nfcip.TamaNfcIpCommunicator;

public class TargetTerminalTagScanner
extends AbstractTerminalTagScanner
implements Runnable {
    public TargetTerminalTagScanner(CardTerminal cardTerminal) {
        super(cardTerminal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            this.notifyStatus(TerminalStatus.WAITING);
            try {
                Card card = this.cardTerminal.connect("direct");
                byte[] historicalBytes = card.getATR().getHistoricalBytes();
                TagType tagType = AcsTagUtils.identifyTagType(historicalBytes);
                ApduTagReaderWriter readerWriter = new ApduTagReaderWriter(new AcsDirectChannelTag(tagType, historicalBytes, card));
                try {
                    TamaNfcIpCommunicator nfcIpCommunicator = new TamaNfcIpCommunicator(readerWriter, readerWriter);
                    nfcIpCommunicator.setNfcId(LlcpConstants.nfcId3t);
                    nfcIpCommunicator.setFelicaParams(LlcpConstants.felicaParams);
                    nfcIpCommunicator.setMifareParams(LlcpConstants.mifareParams);
                    nfcIpCommunicator.setGeneralBytes(LlcpConstants.generalBytes);
                    NFCIPConnection nfcipConnection = nfcIpCommunicator.connectAsTarget();
                    this.handleNfcipConnection(nfcipConnection);
                }
                catch (Exception e1) {
                    card.disconnect(true);
                    e1.printStackTrace();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                finally {
                    this.waitForCardAbsent();
                }
            }
            catch (CardException e) {
                e.printStackTrace();
                break;
            }
        }
    }
}

