/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.nfctools.api.ApduTag;
import org.nfctools.api.TagType;
import org.nfctools.llcp.LlcpConstants;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.scio.TerminalStatus;
import org.nfctools.spi.acs.AbstractTerminalTagScanner;
import org.nfctools.spi.acs.AcsTag;
import org.nfctools.spi.acs.AcsTagUtils;
import org.nfctools.spi.acs.ApduTagReaderWriter;
import org.nfctools.spi.tama.nfcip.TamaNfcIpCommunicator;

public class InitiatorTerminalTagScanner
extends AbstractTerminalTagScanner
implements Runnable {
    public InitiatorTerminalTagScanner(CardTerminal cardTerminal) {
        super(cardTerminal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!Thread.interrupted()) {
            this.notifyStatus(TerminalStatus.WAITING);
            try {
                if (!this.cardTerminal.waitForCardPresent(500L)) continue;
                Card card = null;
                try {
                    card = this.cardTerminal.connect("*");
                    this.notifyStatus(TerminalStatus.CONNECTED);
                    this.handleCard(card);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.waitForCardAbsent();
                }
            }
            catch (CardException e) {
                e.printStackTrace();
            }
        }
    }

    private void handleCard(Card card) {
        byte[] historicalBytes = card.getATR().getHistoricalBytes();
        TagType tagType = AcsTagUtils.identifyTagType(historicalBytes);
        AcsTag acsTag = new AcsTag(tagType, historicalBytes, card);
        if (tagType.equals((Object)TagType.NFCIP)) {
            this.connectAsInitiator(acsTag);
        } else {
            this.tagListener.onTag(acsTag);
        }
    }

    private void connectAsInitiator(ApduTag tag) {
        ApduTagReaderWriter apduReaderWriter = new ApduTagReaderWriter(tag);
        TamaNfcIpCommunicator nfcIpCommunicator = new TamaNfcIpCommunicator(apduReaderWriter, apduReaderWriter);
        nfcIpCommunicator.setConnectionSetup(LlcpConstants.CONNECTION_SETUP);
        try {
            NFCIPConnection nfcipConnection = nfcIpCommunicator.connectAsInitiator();
            this.handleNfcipConnection(nfcipConnection);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

