/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import org.nfctools.api.ApduTag;
import org.nfctools.io.ByteArrayReader;
import org.nfctools.io.ByteArrayWriter;
import org.nfctools.scio.Command;
import org.nfctools.scio.Response;
import org.nfctools.spi.acs.ApduException;
import org.nfctools.utils.NfcUtils;

public class ApduTagReaderWriter
implements ByteArrayReader,
ByteArrayWriter {
    private byte[] responseData;
    private final ApduTag apduTag;

    public ApduTagReaderWriter(ApduTag apduTag) {
        this.apduTag = apduTag;
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        Command command = new Command(data, offset, length);
        Response response = this.apduTag.transmit(command);
        this.responseData = response.getData();
        if (!response.isSuccess()) {
            throw new ApduException("Error sending message [" + NfcUtils.convertBinToASCII(data) + "] (" + offset + "," + length + ") => [SW1: " + response.getSw1() + ", SW2:" + response.getSw2() + ", Data: " + NfcUtils.convertBinToASCII(this.responseData) + "]");
        }
    }

    @Override
    public void setTimeout(long millis) {
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.responseData.length > length - offset) {
            throw new IllegalArgumentException("buffer too small for response, needed " + this.responseData.length + " bytes");
        }
        System.arraycopy(this.responseData, 0, data, offset, this.responseData.length);
        return this.responseData.length;
    }
}

