/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.nfctools.io.ByteArrayReader;
import org.nfctools.io.ByteArrayWriter;
import org.nfctools.spi.acs.ApduException;
import org.nfctools.spi.acs.ApduUtils;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ApduReaderWriter
implements ByteArrayReader,
ByteArrayWriter {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Card card;
    private CardChannel cardChannel;
    private byte[] responseData;

    public ApduReaderWriter(Card card, boolean useBasicChannel) {
        this.card = card;
        if (useBasicChannel) {
            this.cardChannel = card.getBasicChannel();
        }
    }

    @Override
    public void write(byte[] data, int offset, int length) throws IOException {
        try {
            CommandAPDU commandAPDU = new CommandAPDU(255, 0, 0, 0, data, offset, length);
            byte[] commandBytes = commandAPDU.getBytes();
            if (this.log.isDebugEnabled()) {
                this.log.debug("command  APDU => " + NfcUtils.convertBinToASCII(commandBytes));
            }
            ResponseAPDU responseAPDU = null;
            if (this.cardChannel != null) {
                responseAPDU = this.cardChannel.transmit(commandAPDU);
            } else {
                byte[] transmitControlResponse = this.card.transmitControlCommand(3225264, commandBytes);
                responseAPDU = new ResponseAPDU(transmitControlResponse);
            }
            this.responseData = responseAPDU.getData();
            if (this.log.isDebugEnabled()) {
                this.log.debug("response APDU <= " + NfcUtils.convertBinToASCII(this.responseData));
            }
            if (!ApduUtils.isSuccess(responseAPDU)) {
                throw new ApduException("Error sending message [" + NfcUtils.convertBinToASCII(data) + "] (" + offset + "," + length + ") => [" + NfcUtils.convertBinToASCII(this.responseData) + "]");
            }
        }
        catch (CardException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setTimeout(long millis) {
    }

    @Override
    public int read(byte[] data, int offset, int length) throws IOException {
        if (this.responseData.length > length - offset) {
            throw new IllegalArgumentException("buffer too small for response, needed " + this.responseData.length + " bytes");
        }
        System.arraycopy(this.responseData, 0, data, offset, this.responseData.length);
        return this.responseData.length;
    }
}

