/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import java.util.List;
import javax.smartcardio.Card;
import javax.smartcardio.CardException;
import org.nfctools.api.TagListener;
import org.nfctools.llcp.LlcpConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.card.MfCard;
import org.nfctools.mf.ndef.MfNdefReader;
import org.nfctools.ndef.NdefContext;
import org.nfctools.ndef.Record;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;
import org.nfctools.scio.AbstractTerminal;
import org.nfctools.scio.TerminalMode;
import org.nfctools.scio.TerminalStatus;
import org.nfctools.spi.acs.AbstractTerminalTagScanner;
import org.nfctools.spi.acs.Acr122ReaderWriter;
import org.nfctools.spi.acs.ApduReaderWriter;
import org.nfctools.spi.acs.CardResolver;
import org.nfctools.spi.acs.InitiatorTerminalTagScanner;
import org.nfctools.spi.acs.TargetTerminalTagScanner;
import org.nfctools.spi.tama.nfcip.TamaNfcIpCommunicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcsTerminal
extends AbstractTerminal {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private MfReaderWriter mfReaderWriter;
    private Thread scanningThread;
    private AbstractTerminalTagScanner tagScanner;

    @Override
    public boolean canHandle(String terminalName) {
        return terminalName.contains("ACS ACR122");
    }

    @Override
    public void registerTagListener(TagListener tagListener) {
        this.tagScanner.setTagListener(tagListener);
    }

    @Override
    public void setMode(TerminalMode terminalMode) {
        this.tagScanner = TerminalMode.INITIATOR.equals((Object)terminalMode) ? new InitiatorTerminalTagScanner(this.cardTerminal) : new TargetTerminalTagScanner(this.cardTerminal);
        this.scanningThread = new Thread(this.tagScanner);
        this.scanningThread.setDaemon(true);
    }

    @Override
    public void startListening() {
        this.scanningThread.start();
    }

    @Override
    public void stopListening() {
        this.scanningThread.interrupt();
    }

    @Override
    public void setNfcipConnectionListener(NFCIPConnectionListener nfcipConnectionListener) {
        if (this.tagScanner != null) {
            this.tagScanner.setNfcipConnectionListener(nfcipConnectionListener);
        } else {
            super.setNfcipConnectionListener(nfcipConnectionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initInitiatorDep() throws IOException {
        this.mfReaderWriter = new Acr122ReaderWriter(this);
        while (!Thread.interrupted()) {
            this.log.info("Waiting...");
            this.notifyStatus(TerminalStatus.WAITING);
            try {
                if (!this.cardTerminal.waitForCardPresent(500L)) continue;
                Card card = null;
                try {
                    card = this.cardTerminal.connect("*");
                    byte[] historicalBytes = card.getATR().getHistoricalBytes();
                    if (historicalBytes[9] == -1 && historicalBytes[10] == 64) {
                        this.openLlcpStack(card);
                        continue;
                    }
                    this.handleMfCard(card);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (card != null) {
                        card.disconnect(true);
                    }
                    try {
                        while (this.cardTerminal.isCardPresent()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException e) {}
                        }
                        this.cardTerminal.waitForCardAbsent(1000L);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.notifyStatus(TerminalStatus.DISCONNECTED);
                }
            }
            catch (CardException e) {
                throw new IOException(e);
            }
        }
    }

    private void handleMfCard(Card card) throws MfException, IOException {
        CardResolver cardResolver = new CardResolver();
        MfCard mfCard = cardResolver.resolvecard(card);
        this.cardDetected(mfCard, this.mfReaderWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openLlcpStack(Card card) throws IOException {
        ApduReaderWriter apduReaderWriter = new ApduReaderWriter(card, true);
        TamaNfcIpCommunicator nfcIpCommunicator = new TamaNfcIpCommunicator(apduReaderWriter, apduReaderWriter);
        nfcIpCommunicator.setNfcId(LlcpConstants.nfcId3t);
        nfcIpCommunicator.setFelicaParams(LlcpConstants.felicaParams);
        nfcIpCommunicator.setMifareParams(LlcpConstants.mifareParams);
        nfcIpCommunicator.setGeneralBytes(LlcpConstants.initiatorGeneralBytes);
        NFCIPConnection nfcipConnection = nfcIpCommunicator.connectAsInitiator();
        this.log.info("Connection: " + nfcipConnection);
        this.handleNfcipConnection(nfcipConnection);
    }

    @Override
    public void cardDetected(MfCard mfCard, MfReaderWriter mfReaderWriter) throws IOException {
        MfNdefReader ndefReader = new MfNdefReader(mfReaderWriter, NdefContext.getNdefMessageDecoder());
        List<Record> records = ndefReader.readNdefMessage(mfCard);
        if (this.ndefListener != null) {
            this.ndefListener.onNdefMessages(records);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTargetDep() throws IOException {
        try {
            while (true) {
                Card card = this.cardTerminal.connect("direct");
                ApduReaderWriter apduReaderWriter = new ApduReaderWriter(card, false);
                try {
                    this.log.info("Waiting...");
                    this.connectAsTarget(apduReaderWriter);
                    continue;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                    }
                }
                finally {
                    card.disconnect(true);
                    continue;
                }
                break;
            }
        }
        catch (CardException e) {
            throw new IOException(e);
        }
    }

    private void connectAsTarget(ApduReaderWriter apduReaderWriter) throws IOException {
        TamaNfcIpCommunicator nfcIpCommunicator = new TamaNfcIpCommunicator(apduReaderWriter, apduReaderWriter);
        nfcIpCommunicator.setNfcId(LlcpConstants.nfcId3t);
        nfcIpCommunicator.setFelicaParams(LlcpConstants.felicaParams);
        nfcIpCommunicator.setMifareParams(LlcpConstants.mifareParams);
        nfcIpCommunicator.setGeneralBytes(LlcpConstants.generalBytes);
        NFCIPConnection nfcipConnection = nfcIpCommunicator.connectAsTarget();
        this.log.info("Connection: " + nfcipConnection);
        this.handleNfcipConnection(nfcipConnection);
    }
}

