/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import org.nfctools.api.TagType;
import org.nfctools.utils.NfcUtils;

public class AcsTagUtils {
    public static TagType identifyTagType(byte[] historicalBytes) {
        TagType tagType = TagType.UKNOWN;
        if (historicalBytes.length >= 11) {
            int tagId = (historicalBytes[9] & 0xFF) << 8 | historicalBytes[10];
            switch (tagId) {
                case 1: {
                    return TagType.MIFARE_CLASSIC_1K;
                }
                case 2: {
                    return TagType.MIFARE_CLASSIC_4K;
                }
                case 3: {
                    return TagType.MIFARE_ULTRALIGHT;
                }
                case 38: {
                    return TagType.MIFARE_MINI;
                }
                case 61444: {
                    return TagType.TOPAZ_JEWEL;
                }
                case 61457: {
                    return TagType.FELICA_212K;
                }
                case 61458: {
                    return TagType.FELICA_424K;
                }
                case 65344: {
                    return TagType.NFCIP;
                }
            }
        } else {
            System.out.println(NfcUtils.convertBinToASCII(historicalBytes));
        }
        return tagType;
    }
}

