/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.nfctools.NfcException;
import org.nfctools.api.ApduTag;
import org.nfctools.api.Tag;
import org.nfctools.api.TagType;
import org.nfctools.scio.Command;
import org.nfctools.scio.Response;
import org.nfctools.utils.NfcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcsTag
extends Tag
implements ApduTag {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Card card;
    private CardChannel cardChannel;

    public AcsTag(TagType tagType, byte[] generalBytes, Card card) {
        super(tagType, generalBytes);
        this.card = card;
        this.cardChannel = card.getBasicChannel();
    }

    public Card getCard() {
        return this.card;
    }

    @Override
    public Response transmit(Command command) {
        try {
            CommandAPDU commandAPDU = null;
            commandAPDU = command.isDataOnly() ? new CommandAPDU(255, 0, 0, 0, command.getData(), command.getOffset(), command.getLength()) : (command.hasData() ? new CommandAPDU(255, command.getInstruction(), command.getP1(), command.getP2(), command.getData()) : new CommandAPDU(255, command.getInstruction(), command.getP1(), command.getP2(), command.getLength()));
            if (this.log.isDebugEnabled()) {
                this.log.debug("command: " + NfcUtils.convertBinToASCII(commandAPDU.getBytes()));
            }
            ResponseAPDU responseAPDU = this.cardChannel.transmit(commandAPDU);
            if (this.log.isDebugEnabled()) {
                this.log.debug("response: " + NfcUtils.convertBinToASCII(responseAPDU.getBytes()));
            }
            return new Response(responseAPDU.getSW1(), responseAPDU.getSW2(), responseAPDU.getData());
        }
        catch (CardException e) {
            throw new NfcException(e);
        }
    }
}

