/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import org.nfctools.io.NfcDevice;
import org.nfctools.mf.MfAccess;
import org.nfctools.mf.MfCardListener;
import org.nfctools.mf.MfException;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.block.Block;
import org.nfctools.mf.block.BlockResolver;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.card.MfCard;
import org.nfctools.mf.classic.Key;
import org.nfctools.scio.CardTerminalToken;
import org.nfctools.spi.acs.AcsConnectionToken;
import org.nfctools.spi.acs.ApduUtils;
import org.nfctools.spi.acs.PollingCardScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AcsReaderWriter
implements MfReaderWriter {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected BlockResolver blockResolver = new BlockResolver();
    protected CardTerminal cardTerminal;
    private Thread pollingThread = null;

    protected AcsReaderWriter(NfcDevice nfcDevice) {
        if (!(nfcDevice.getConnectionToken() instanceof CardTerminalToken)) {
            throw new IllegalArgumentException("unsupported connection token");
        }
        this.cardTerminal = ((CardTerminalToken)nfcDevice.getConnectionToken()).getCardTerminal();
    }

    @Override
    public void setCardIntoHalt(MfCard card) throws IOException {
        try {
            AcsConnectionToken connectionToken = (AcsConnectionToken)card.getConnectionToken();
            connectionToken.getCard().disconnect(true);
        }
        catch (CardException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void reselectCard(MfCard card) throws IOException {
    }

    @Override
    public MfBlock[] readBlock(MfAccess mfAccess) throws IOException {
        AcsConnectionToken connectionToken = this.retrieveConnectionToken(mfAccess);
        CardChannel cardChannel = connectionToken.getCard().getBasicChannel();
        this.loginIntoSector(mfAccess, cardChannel);
        MfBlock[] returnBlocks = new Block[mfAccess.getBlocksToRead()];
        for (int currentBlock = 0; currentBlock < mfAccess.getBlocksToRead(); ++currentBlock) {
            ResponseAPDU readBlockResponse;
            byte blockNumber = (byte)mfAccess.getCard().getBlockNumber(mfAccess.getSector(), mfAccess.getBlock() + currentBlock);
            CommandAPDU readBlock = new CommandAPDU(255, 176, 0, (int)blockNumber, 16);
            try {
                readBlockResponse = cardChannel.transmit(readBlock);
                if (!ApduUtils.isSuccess(readBlockResponse)) {
                    throw new MfException("Reading block failed. Sector: " + mfAccess.getSector() + ", Block: " + mfAccess.getBlock() + " Key: " + mfAccess.getKey().name() + ", Response: " + readBlockResponse);
                }
            }
            catch (CardException e) {
                throw new IOException(e);
            }
            returnBlocks[currentBlock] = BlockResolver.resolveBlock(mfAccess.getCard(), mfAccess.getSector(), currentBlock + mfAccess.getBlock(), readBlockResponse.getData());
        }
        return returnBlocks;
    }

    protected abstract void loginIntoSector(MfAccess var1, CardChannel var2) throws IOException;

    protected void loginIntoSector(MfAccess mfAccess, CardChannel cardChannel, byte memoryKeyId) throws IOException {
        try {
            byte keyTypeToUse;
            CommandAPDU loadKey = new CommandAPDU(255, 130, 0, (int)memoryKeyId, mfAccess.getKeyValue());
            ResponseAPDU loadKeyResponse = cardChannel.transmit(loadKey);
            if (!ApduUtils.isSuccess(loadKeyResponse)) {
                throw new MfLoginException("Loading key failed. Sector: " + mfAccess.getSector() + ", Block: " + mfAccess.getBlock() + " Key: " + mfAccess.getKey().name() + ", Response: " + loadKeyResponse);
            }
            byte blockNumber = (byte)mfAccess.getCard().getBlockNumber(mfAccess.getSector(), mfAccess.getBlock());
            CommandAPDU auth = new CommandAPDU(255, 134, 0, 0, new byte[]{1, 0, blockNumber, keyTypeToUse = mfAccess.getKey() == Key.A ? (byte)96 : 97, memoryKeyId});
            ResponseAPDU authResponse = cardChannel.transmit(auth);
            if (!ApduUtils.isSuccess(authResponse)) {
                throw new MfLoginException("Login failed. Sector: " + mfAccess.getSector() + ", Block: " + mfAccess.getBlock() + " Key: " + mfAccess.getKey().name() + ", Response: " + authResponse);
            }
        }
        catch (CardException e) {
            throw new IOException(e);
        }
    }

    private AcsConnectionToken retrieveConnectionToken(MfAccess mfAccess) {
        return (AcsConnectionToken)mfAccess.getCard().getConnectionToken();
    }

    @Override
    public void writeBlock(MfAccess mfAccess, MfBlock ... mfBlock) throws IOException {
        AcsConnectionToken connectionToken = this.retrieveConnectionToken(mfAccess);
        CardChannel cardChannel = connectionToken.getCard().getBasicChannel();
        this.loginIntoSector(mfAccess, cardChannel);
        for (int currentBlock = 0; currentBlock < mfBlock.length; ++currentBlock) {
            int blockNumber = mfAccess.getCard().getBlockNumber(mfAccess.getSector(), mfAccess.getBlock()) + currentBlock;
            if (mfAccess.getCard().isTrailerBlock(mfAccess.getSector(), mfAccess.getBlock() + currentBlock) && !(mfBlock[currentBlock] instanceof TrailerBlock)) {
                throw new MfException("invalid block for trailer");
            }
            CommandAPDU writeBlock = new CommandAPDU(255, 214, 0, blockNumber, mfBlock[currentBlock].getData());
            try {
                ResponseAPDU writeBlockResponse = cardChannel.transmit(writeBlock);
                if (ApduUtils.isSuccess(writeBlockResponse)) continue;
                throw new MfException("Writing block failed. Sector: " + mfAccess.getSector() + ", Block: " + mfAccess.getBlock() + " Key: " + mfAccess.getKey().name() + ", Response: " + writeBlockResponse);
            }
            catch (CardException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public void setCardListener(MfCardListener cardListener) throws IOException {
        this.pollingThread = new Thread(new PollingCardScanner(this.cardTerminal, cardListener, this));
        this.pollingThread.setDaemon(false);
        this.log.debug("Starting new thread " + this.pollingThread.getName());
        this.pollingThread.start();
    }

    @Override
    public boolean waitForCard(MfCardListener mfCardListener, int timeout) throws IOException {
        this.removeCardListener();
        try {
            return new PollingCardScanner(this.cardTerminal, mfCardListener, this).waitForCard(timeout);
        }
        catch (CardException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void removeCardListener() {
        if (this.pollingThread != null && this.pollingThread.isAlive()) {
            this.pollingThread.interrupt();
        }
    }
}

