/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import org.nfctools.api.ApduTag;
import org.nfctools.mf.MfException;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.ul.DataBlock;
import org.nfctools.mf.ul.MfUlReaderWriter;
import org.nfctools.scio.Command;
import org.nfctools.scio.Response;

public class AcrMfUlReaderWriter
implements MfUlReaderWriter {
    private ApduTag tag;

    public AcrMfUlReaderWriter(ApduTag tag) {
        this.tag = tag;
    }

    @Override
    public MfBlock[] readBlock(int startPage, int pagesToRead) throws IOException {
        MfBlock[] returnBlocks = new MfBlock[pagesToRead];
        for (int currentPage = 0; currentPage < pagesToRead; ++currentPage) {
            int pageNumber = startPage + currentPage;
            Command readBlock = new Command(176, 0, pageNumber, 4);
            Response readBlockResponse = this.tag.transmit(readBlock);
            if (!readBlockResponse.isSuccess()) {
                throw new MfException("Reading block failed. Page: " + pageNumber + ", Response: " + readBlockResponse);
            }
            returnBlocks[currentPage] = new DataBlock(readBlockResponse.getData());
        }
        return returnBlocks;
    }

    @Override
    public void writeBlock(int startPage, MfBlock ... mfBlock) throws IOException {
        for (int currentBlock = 0; currentBlock < mfBlock.length; ++currentBlock) {
            int blockNumber = startPage + currentBlock;
            Command writeBlock = new Command(214, 0, blockNumber, mfBlock[currentBlock].getData());
            Response writeBlockResponse = this.tag.transmit(writeBlock);
            if (writeBlockResponse.isSuccess()) continue;
            throw new MfException("Writing block failed. Page: " + blockNumber + ", Response: " + writeBlockResponse);
        }
    }
}

