/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import org.nfctools.api.ApduTag;
import org.nfctools.mf.MfConstants;
import org.nfctools.mf.MfException;
import org.nfctools.mf.MfLoginException;
import org.nfctools.mf.block.Block;
import org.nfctools.mf.block.BlockResolver;
import org.nfctools.mf.block.MfBlock;
import org.nfctools.mf.block.TrailerBlock;
import org.nfctools.mf.classic.Key;
import org.nfctools.mf.classic.MemoryLayout;
import org.nfctools.mf.classic.MfClassicAccess;
import org.nfctools.mf.classic.MfClassicConstants;
import org.nfctools.mf.classic.MfClassicReaderWriter;
import org.nfctools.mf.mad.AbstractMad;
import org.nfctools.mf.mad.ApplicationDirectory;
import org.nfctools.mf.mad.MadKeyConfig;
import org.nfctools.scio.Command;
import org.nfctools.scio.Response;

public class AcrMfClassicReaderWriter
implements MfClassicReaderWriter {
    private ApduTag apduTag;
    private MemoryLayout memoryLayout;

    public AcrMfClassicReaderWriter(ApduTag apduTag, MemoryLayout memoryLayout) {
        this.apduTag = apduTag;
        this.memoryLayout = memoryLayout;
    }

    @Override
    public MfBlock[] readBlock(MfClassicAccess access) throws IOException {
        this.loginIntoSector(access, (byte)0);
        MfBlock[] returnBlocks = new Block[access.getBlocksToRead()];
        for (int currentBlock = 0; currentBlock < access.getBlocksToRead(); ++currentBlock) {
            byte blockNumber = (byte)this.memoryLayout.getBlockNumber(access.getSector(), access.getBlock() + currentBlock);
            Command readBlock = new Command(176, 0, (int)blockNumber, 16);
            Response readBlockResponse = this.apduTag.transmit(readBlock);
            if (!readBlockResponse.isSuccess()) {
                throw new MfException("Reading block failed. Sector: " + access.getSector() + ", Block: " + access.getBlock() + " Key: " + access.getKeyValue().getKey().name() + ", Response: " + readBlockResponse);
            }
            returnBlocks[currentBlock] = BlockResolver.resolveBlock(this.memoryLayout, access.getSector(), currentBlock + access.getBlock(), readBlockResponse.getData());
        }
        return returnBlocks;
    }

    @Override
    public void writeBlock(MfClassicAccess access, MfBlock ... mfBlock) throws IOException {
        this.loginIntoSector(access, (byte)0);
        for (int currentBlock = 0; currentBlock < mfBlock.length; ++currentBlock) {
            int blockNumber = this.memoryLayout.getBlockNumber(access.getSector(), access.getBlock()) + currentBlock;
            if (this.memoryLayout.isTrailerBlock(access.getSector(), access.getBlock() + currentBlock) && !(mfBlock[currentBlock] instanceof TrailerBlock)) {
                throw new MfException("invalid block for trailer");
            }
            Command writeBlock = new Command(214, 0, blockNumber, mfBlock[currentBlock].getData());
            Response writeBlockResponse = this.apduTag.transmit(writeBlock);
            if (writeBlockResponse.isSuccess()) continue;
            throw new MfException("Writing block failed. Sector: " + access.getSector() + ", Block: " + access.getBlock() + " Key: " + access.getKeyValue().getKey().name() + ", Response: " + writeBlockResponse);
        }
    }

    @Override
    public MemoryLayout getMemoryLayout() {
        return this.memoryLayout;
    }

    protected void loginIntoSector(MfClassicAccess access, byte memoryKeyId) throws IOException {
        byte keyTypeToUse;
        Command loadKey = new Command(130, 0, (int)memoryKeyId, access.getKeyValue().getKeyValue());
        Response loadKeyResponse = this.apduTag.transmit(loadKey);
        if (!loadKeyResponse.isSuccess()) {
            throw new MfLoginException("Loading key failed. Sector: " + access.getSector() + ", Block: " + access.getBlock() + " Key: " + access.getKeyValue().getKey().name() + ", Response: " + loadKeyResponse);
        }
        byte blockNumber = (byte)this.memoryLayout.getBlockNumber(access.getSector(), access.getBlock());
        Command auth = new Command(134, 0, 0, new byte[]{1, 0, blockNumber, keyTypeToUse = access.getKeyValue().getKey() == Key.A ? (byte)96 : 97, memoryKeyId});
        Response authResponse = this.apduTag.transmit(auth);
        if (!authResponse.isSuccess()) {
            throw new MfLoginException("Login failed. Sector: " + access.getSector() + ", Block: " + access.getBlock() + " Key: " + access.getKeyValue().getKey().name() + ", Response: " + authResponse);
        }
    }

    @Override
    public boolean hasApplicationDirectory() throws IOException {
        try {
            MfClassicAccess access = new MfClassicAccess(MfClassicConstants.MAD_KEY, 0, this.memoryLayout.getTrailerBlockNumberForSector(0));
            TrailerBlock madTrailer = (TrailerBlock)this.readBlock(access)[0];
            return (madTrailer.getGeneralPurposeByte() & 0x80) != 0;
        }
        catch (MfLoginException e) {
            return false;
        }
    }

    @Override
    public ApplicationDirectory createApplicationDirectory(MadKeyConfig keyConfig) throws IOException {
        return AbstractMad.createInstance(this, keyConfig);
    }

    @Override
    public ApplicationDirectory getApplicationDirectory() throws IOException {
        return this.getApplicationDirectory(MfConstants.NDEF_KEY_CONFIG);
    }

    @Override
    public ApplicationDirectory getApplicationDirectory(MadKeyConfig keyConfig) throws IOException {
        return AbstractMad.initInstance(this, keyConfig);
    }
}

