/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.spi.acs;

import java.io.IOException;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import org.nfctools.api.TagListener;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;
import org.nfctools.scio.TerminalStatus;
import org.nfctools.scio.TerminalStatusListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTerminalTagScanner
implements Runnable {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected CardTerminal cardTerminal;
    protected TerminalStatusListener statusListener;
    protected TagListener tagListener;
    protected NFCIPConnectionListener nfcipConnectionListener;

    protected AbstractTerminalTagScanner(CardTerminal cardTerminal) {
        this.cardTerminal = cardTerminal;
    }

    protected void notifyStatus(TerminalStatus status) {
        if (this.statusListener != null) {
            this.statusListener.onStatusChanged(status);
        }
    }

    protected void waitForCardAbsent() throws CardException {
        try {
            while (this.cardTerminal.isCardPresent()) {
                try {
                    this.log.debug("Waiting while card present");
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            this.log.debug("Wait for card absent");
            this.cardTerminal.waitForCardAbsent(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.log.debug("Disconnected");
        this.notifyStatus(TerminalStatus.DISCONNECTED);
    }

    public void setNfcipConnectionListener(NFCIPConnectionListener nfcipConnectionListener) {
        this.nfcipConnectionListener = nfcipConnectionListener;
    }

    public void setTagListener(TagListener tagListener) {
        this.tagListener = tagListener;
    }

    public void setStatusListener(TerminalStatusListener statusListener) {
        this.statusListener = statusListener;
    }

    protected void handleNfcipConnection(NFCIPConnection nfcipConnection) throws IOException {
        if (nfcipConnection != null && this.nfcipConnectionListener != null) {
            this.nfcipConnectionListener.onConnection(nfcipConnection);
        }
    }
}

