/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.scio;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.smartcardio.CardException;
import javax.smartcardio.CardTerminal;
import javax.smartcardio.TerminalFactory;
import org.nfctools.scio.Terminal;

public class TerminalHandler {
    private Logger log = Logger.getLogger(TerminalHandler.class.getName());
    private Collection<Terminal> knownTerminals = new HashSet<Terminal>();

    public void addTerminal(Terminal terminal) {
        this.knownTerminals.add(terminal);
    }

    public Terminal getAvailableTerminal() {
        return this.getAvailableTerminal(null);
    }

    public Terminal getAvailableTerminal(String preferredTerminalName) {
        try {
            TerminalFactory terminalFactory = TerminalFactory.getDefault();
            List<CardTerminal> terminals = terminalFactory.terminals().list();
            for (CardTerminal terminal : terminals) {
                this.log.info("Checking terminal: " + terminal.getName());
                if (preferredTerminalName != null && !preferredTerminalName.equals(terminal.getName())) continue;
                for (Terminal knownTerminal : this.knownTerminals) {
                    if (!knownTerminal.canHandle(terminal.getName())) continue;
                    knownTerminal.setCardTerminal(terminal);
                    return knownTerminal;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (CardTerminal terminal : terminals) {
                sb.append(" [").append(terminal.getName()).append("]");
            }
            throw new IllegalArgumentException("No supported card terminal found. Available Terminals " + sb.toString());
        }
        catch (CardException e) {
            throw new RuntimeException(e);
        }
    }
}

