/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.scio;

import java.io.IOException;
import javax.smartcardio.CardTerminal;
import org.nfctools.mf.MfCardListener;
import org.nfctools.mf.MfReaderWriter;
import org.nfctools.mf.card.MfCard;
import org.nfctools.ndef.NdefListener;
import org.nfctools.nfcip.NFCIPConnection;
import org.nfctools.nfcip.NFCIPConnectionListener;
import org.nfctools.scio.CardTerminalToken;
import org.nfctools.scio.Terminal;
import org.nfctools.scio.TerminalStatus;
import org.nfctools.scio.TerminalStatusListener;

public abstract class AbstractTerminal
implements Terminal,
MfCardListener {
    protected CardTerminal cardTerminal;
    protected NFCIPConnectionListener nfcipConnectionListener;
    protected TerminalStatusListener statusListener;
    protected NdefListener ndefListener;
    protected CardTerminalToken cardTerminalToken = new CardTerminalToken();

    @Override
    public void setCardTerminal(CardTerminal cardTerminal) {
        this.cardTerminal = cardTerminal;
        this.cardTerminalToken.setCardTerminal(cardTerminal);
    }

    @Override
    public String getTerminalName() {
        return this.cardTerminal.getName();
    }

    @Override
    public CardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    @Override
    public void setStatusListener(TerminalStatusListener statusListener) {
        this.statusListener = statusListener;
    }

    @Override
    public void setNfcipConnectionListener(NFCIPConnectionListener nfcipConnectionListener) {
        this.nfcipConnectionListener = nfcipConnectionListener;
    }

    protected void notifyStatus(TerminalStatus status) {
        if (this.statusListener != null) {
            this.statusListener.onStatusChanged(status);
        }
    }

    protected void handleNfcipConnection(NFCIPConnection nfcipConnection) throws IOException {
        if (nfcipConnection != null && this.nfcipConnectionListener != null) {
            this.notifyStatus(TerminalStatus.CONNECTED);
            this.nfcipConnectionListener.onConnection(nfcipConnection);
        }
    }

    @Override
    public void setNdefListener(NdefListener ndefListener) {
        this.ndefListener = ndefListener;
    }

    @Override
    public CardTerminalToken getConnectionToken() {
        return this.cardTerminalToken;
    }

    @Override
    public void cardDetected(MfCard mfCard, MfReaderWriter mfReaderWriter) throws IOException {
    }

    @Override
    public void open() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

