/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.records;

import org.nfctools.ndef.wkt.records.GcActionRecord;
import org.nfctools.ndef.wkt.records.GcDataRecord;
import org.nfctools.ndef.wkt.records.GcTargetRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class GenericControlRecord
extends WellKnownRecord {
    private static final byte CB_CHECK_EXIT_CONDITION = 2;
    private static final byte CB_IGNORE_FOLLOWING_IF_FAILED = 4;
    private byte configurationByte;
    private GcTargetRecord target;
    private GcActionRecord action;
    private GcDataRecord data;

    public GenericControlRecord(GcTargetRecord target) {
        this.target = target;
    }

    public GenericControlRecord(GcTargetRecord target, byte configurationByte) {
        this.target = target;
        this.configurationByte = configurationByte;
    }

    public GenericControlRecord() {
    }

    public void setConfigurationByte(byte configurationByte) {
        this.configurationByte = configurationByte;
    }

    public byte getConfigurationByte() {
        return this.configurationByte;
    }

    public boolean isIgnoreFollowingIfFailed() {
        return (this.configurationByte & 4) != 0;
    }

    public void setIgnoreFollowingIfFailed() {
        this.configurationByte = (byte)(this.configurationByte | 4);
    }

    public boolean isCheckExitCondition() {
        return (this.configurationByte & 2) != 0;
    }

    public void setCheckExitCondition() {
        this.configurationByte = (byte)(this.configurationByte | 2);
    }

    public GcTargetRecord getTarget() {
        return this.target;
    }

    public void setTarget(GcTargetRecord target) {
        this.target = target;
    }

    public GcActionRecord getAction() {
        return this.action;
    }

    public void setAction(GcActionRecord action) {
        this.action = action;
    }

    public GcDataRecord getData() {
        return this.data;
    }

    public void setData(GcDataRecord data) {
        this.data = data;
    }

    public String toString() {
        return "GenericControl: [" + this.getTarget() + ", " + this.getAction() + ", " + this.getData() + "]";
    }

    public boolean hasTarget() {
        return this.target != null;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public boolean hasData() {
        return this.data != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + this.configurationByte;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.target == null ? 0 : this.target.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericControlRecord other = (GenericControlRecord)obj;
        if (this.action == null ? other.action != null : !this.action.equals(other.action)) {
            return false;
        }
        if (this.configurationByte != other.configurationByte) {
            return false;
        }
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.target == null ? other.target != null : !this.target.equals(other.target));
    }
}

