/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.records;

import java.util.ArrayList;
import java.util.List;
import org.nfctools.ndef.wkt.handover.records.AlternativeCarrierRecord;
import org.nfctools.ndef.wkt.handover.records.CollisionResolutionRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverRequestRecord
extends WellKnownRecord {
    private byte majorVersion = 1;
    private byte minorVersion = (byte)2;
    private CollisionResolutionRecord collisionResolution;
    private List<AlternativeCarrierRecord> alternativeCarriers;

    public HandoverRequestRecord() {
        this.alternativeCarriers = new ArrayList<AlternativeCarrierRecord>();
    }

    public HandoverRequestRecord(CollisionResolutionRecord collisionResolution) {
        this(collisionResolution, new ArrayList<AlternativeCarrierRecord>());
    }

    public HandoverRequestRecord(CollisionResolutionRecord collisionResolution, List<AlternativeCarrierRecord> alternativeCarriers) {
        this.collisionResolution = collisionResolution;
        this.alternativeCarriers = alternativeCarriers;
    }

    public HandoverRequestRecord(byte majorVersion, byte minorVersion, CollisionResolutionRecord collisionResolution, List<AlternativeCarrierRecord> alternativeCarriers) {
        this(collisionResolution, alternativeCarriers);
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(byte majorVersion) {
        this.majorVersion = majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(byte minorVersion) {
        this.minorVersion = minorVersion;
    }

    public List<AlternativeCarrierRecord> getAlternativeCarriers() {
        return this.alternativeCarriers;
    }

    public void setAlternativeCarriers(List<AlternativeCarrierRecord> alternativeCarriers) {
        this.alternativeCarriers = alternativeCarriers;
    }

    public CollisionResolutionRecord getCollisionResolution() {
        return this.collisionResolution;
    }

    public void setCollisionResolution(CollisionResolutionRecord collisionResolution) {
        this.collisionResolution = collisionResolution;
    }

    public boolean hasAlternativeCarriers() {
        return !this.alternativeCarriers.isEmpty();
    }

    public void add(AlternativeCarrierRecord alternativeCarrierRecord) {
        this.alternativeCarriers.add(alternativeCarrierRecord);
    }

    public boolean hasCollisionResolution() {
        return this.collisionResolution != null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.alternativeCarriers == null ? 0 : this.alternativeCarriers.hashCode());
        result = 31 * result + (this.collisionResolution == null ? 0 : this.collisionResolution.hashCode());
        result = 31 * result + this.majorVersion;
        result = 31 * result + this.minorVersion;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HandoverRequestRecord other = (HandoverRequestRecord)obj;
        if (this.alternativeCarriers == null ? other.alternativeCarriers != null : !this.alternativeCarriers.equals(other.alternativeCarriers)) {
            return false;
        }
        if (this.collisionResolution == null ? other.collisionResolution != null : !this.collisionResolution.equals(other.collisionResolution)) {
            return false;
        }
        if (this.majorVersion != other.majorVersion) {
            return false;
        }
        return this.minorVersion == other.minorVersion;
    }
}

