/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.records;

import java.util.Arrays;
import org.nfctools.ndef.ext.UnsupportedExternalTypeRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverCarrierRecord
extends WellKnownRecord {
    private CarrierTypeFormat carrierTypeFormat;
    private Object carrierType;
    private byte[] carrierData;

    public HandoverCarrierRecord(CarrierTypeFormat carrierTypeFormat, UnsupportedExternalTypeRecord carrierType, byte[] carrierData) {
        this.carrierTypeFormat = carrierTypeFormat;
        this.carrierType = carrierType;
        this.carrierData = carrierData;
    }

    public HandoverCarrierRecord(CarrierTypeFormat carrierTypeFormat, WellKnownRecord carrierType, byte[] carrierData) {
        this.carrierTypeFormat = carrierTypeFormat;
        this.carrierType = carrierType;
        this.carrierData = carrierData;
    }

    public HandoverCarrierRecord() {
    }

    public HandoverCarrierRecord(CarrierTypeFormat carrierTypeFormat, String carrierType, byte[] carrierData) {
        this.carrierTypeFormat = carrierTypeFormat;
        this.carrierType = carrierType;
        this.carrierData = carrierData;
    }

    public CarrierTypeFormat getCarrierTypeFormat() {
        return this.carrierTypeFormat;
    }

    public void setCarrierTypeFormat(CarrierTypeFormat carrierTypeFormat) {
        this.carrierTypeFormat = carrierTypeFormat;
    }

    public Object getCarrierType() {
        return this.carrierType;
    }

    public void setCarrierType(Object carrierType) {
        this.carrierType = carrierType;
    }

    public byte[] getCarrierData() {
        return this.carrierData;
    }

    public void setCarrierData(byte[] carrierData) {
        this.carrierData = carrierData;
    }

    public boolean hasCarrierData() {
        return this.carrierData != null;
    }

    public int getCarrierDataSize() {
        return this.carrierData.length;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.carrierData);
        result = 31 * result + (this.carrierType == null ? 0 : this.carrierType.hashCode());
        result = 31 * result + (this.carrierTypeFormat == null ? 0 : this.carrierTypeFormat.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HandoverCarrierRecord other = (HandoverCarrierRecord)obj;
        if (!Arrays.equals(this.carrierData, other.carrierData)) {
            return false;
        }
        if (this.carrierType == null ? other.carrierType != null : !this.carrierType.equals(other.carrierType)) {
            return false;
        }
        return this.carrierTypeFormat == other.carrierTypeFormat;
    }

    public boolean hasCarrierTypeFormat() {
        return this.carrierTypeFormat != null;
    }

    public boolean hasCarrierType() {
        return this.carrierType != null;
    }

    public static enum CarrierTypeFormat {
        WellKnown(1),
        Media(2),
        AbsoluteURI(3),
        External(4);

        private byte value;

        private CarrierTypeFormat(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static CarrierTypeFormat toCarrierTypeFormat(byte value) {
            for (CarrierTypeFormat carrierTypeFormat : CarrierTypeFormat.values()) {
                if (carrierTypeFormat.value != value) continue;
                return carrierTypeFormat;
            }
            throw new IllegalArgumentException("Unknown carrier type format " + value);
        }
    }
}

