/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.records;

import java.util.ArrayList;
import java.util.List;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class AlternativeCarrierRecord
extends WellKnownRecord {
    private CarrierPowerState carrierPowerState;
    private String carrierDataReference;
    private List<String> auxiliaryDataReferences;

    public AlternativeCarrierRecord() {
        this(new ArrayList<String>());
    }

    public AlternativeCarrierRecord(List<String> auxiliaryDataReferences) {
        this.auxiliaryDataReferences = auxiliaryDataReferences;
    }

    public AlternativeCarrierRecord(CarrierPowerState carrierPowerState, String carrierDataReference) {
        this(carrierPowerState, carrierDataReference, new ArrayList<String>());
    }

    public AlternativeCarrierRecord(CarrierPowerState carrierPowerState, String carrierDataReference, List<String> auxiliaryDataReferences) {
        this(auxiliaryDataReferences);
        this.carrierPowerState = carrierPowerState;
        this.carrierDataReference = carrierDataReference;
    }

    public CarrierPowerState getCarrierPowerState() {
        return this.carrierPowerState;
    }

    public void setCarrierPowerState(CarrierPowerState carrierPowerState) {
        this.carrierPowerState = carrierPowerState;
    }

    public String getCarrierDataReference() {
        return this.carrierDataReference;
    }

    public void setCarrierDataReference(String carrierDataReference) {
        this.carrierDataReference = carrierDataReference;
    }

    public List<String> getAuxiliaryDataReferences() {
        return this.auxiliaryDataReferences;
    }

    public void setAuxiliaryDataReferences(List<String> auxiliaryDataReference) {
        this.auxiliaryDataReferences = auxiliaryDataReference;
    }

    public void addAuxiliaryDataReference(String string) {
        this.auxiliaryDataReferences.add(string);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.auxiliaryDataReferences == null ? 0 : this.auxiliaryDataReferences.hashCode());
        result = 31 * result + (this.carrierDataReference == null ? 0 : this.carrierDataReference.hashCode());
        result = 31 * result + (this.carrierPowerState == null ? 0 : this.carrierPowerState.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlternativeCarrierRecord other = (AlternativeCarrierRecord)obj;
        if (this.auxiliaryDataReferences == null ? other.auxiliaryDataReferences != null : !this.auxiliaryDataReferences.equals(other.auxiliaryDataReferences)) {
            return false;
        }
        if (this.carrierDataReference == null ? other.carrierDataReference != null : !this.carrierDataReference.equals(other.carrierDataReference)) {
            return false;
        }
        return this.carrierPowerState == other.carrierPowerState;
    }

    public boolean hasCarrierPowerState() {
        return this.carrierPowerState != null;
    }

    public String getAuxiliaryDataReferenceAt(int index) {
        return this.auxiliaryDataReferences.get(index);
    }

    public void setAuxiliaryDataReference(int index, String reference) {
        this.auxiliaryDataReferences.set(index, reference);
    }

    public boolean hasCarrierDataReference() {
        return this.carrierDataReference != null;
    }

    public void insertAuxiliaryDataReference(String reference, int index) {
        this.auxiliaryDataReferences.add(index, reference);
    }

    public void removeAuxiliaryDataReference(int index) {
        this.auxiliaryDataReferences.remove(index);
    }

    public boolean hasAuxiliaryDataReferences() {
        return !this.auxiliaryDataReferences.isEmpty();
    }

    public static enum CarrierPowerState {
        Inactive(0),
        Active(1),
        Activating(2),
        Unknown(3);

        private byte value;

        private CarrierPowerState(byte value) {
            this.value = value;
        }

        public byte getValue() {
            return this.value;
        }

        public static CarrierPowerState toCarrierPowerState(byte value) {
            for (CarrierPowerState state : CarrierPowerState.values()) {
                if (state.value != value) continue;
                return state;
            }
            throw new IllegalArgumentException("Unknown carrier power state " + value);
        }
    }
}

