/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.encoder;

import java.io.ByteArrayOutputStream;
import java.util.List;
import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.handover.records.AlternativeCarrierRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class AlternativeCarrierRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        AlternativeCarrierRecord alternativeCarrierRecord = (AlternativeCarrierRecord)wellKnownRecord;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        AlternativeCarrierRecord.CarrierPowerState carrierPowerState = alternativeCarrierRecord.getCarrierPowerState();
        if (carrierPowerState == null) {
            throw new NdefEncoderException("Expected carrier power state", alternativeCarrierRecord);
        }
        bout.write(carrierPowerState.getValue() & 7);
        String carrierDataReference = alternativeCarrierRecord.getCarrierDataReference();
        if (carrierDataReference == null) {
            throw new NdefEncoderException("Expected carrier data reference", alternativeCarrierRecord);
        }
        byte[] carrierDataReferenceChar = carrierDataReference.getBytes(NdefConstants.DEFAULT_CHARSET);
        if (carrierDataReferenceChar.length > 255) {
            throw new NdefEncoderException("Expected carrier data reference '" + carrierDataReference + "' <= 255 bytes", alternativeCarrierRecord);
        }
        bout.write(carrierDataReferenceChar.length);
        bout.write(carrierDataReferenceChar, 0, carrierDataReferenceChar.length);
        List<String> auxiliaryDataReferences = alternativeCarrierRecord.getAuxiliaryDataReferences();
        bout.write(auxiliaryDataReferences.size());
        for (String auxiliaryDataReference : auxiliaryDataReferences) {
            byte[] auxiliaryDataReferenceChar = auxiliaryDataReference.getBytes(NdefConstants.DEFAULT_CHARSET);
            if (auxiliaryDataReferenceChar.length > 255) {
                throw new NdefEncoderException("Expected auxiliary data reference '" + auxiliaryDataReference + "' <= 255 bytes", alternativeCarrierRecord);
            }
            bout.write(auxiliaryDataReferenceChar.length);
            bout.write(auxiliaryDataReferenceChar, 0, auxiliaryDataReferenceChar.length);
        }
        bout.write(0);
        return bout.toByteArray();
    }
}

