/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.decoder;

import java.util.List;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.handover.records.AlternativeCarrierRecord;
import org.nfctools.ndef.wkt.handover.records.CollisionResolutionRecord;
import org.nfctools.ndef.wkt.handover.records.HandoverRequestRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class HandoverRequestRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        HandoverRequestRecord handoverRequestRecord = new HandoverRequestRecord();
        byte minorVersion = (byte)(payload[0] & 0xF);
        byte majorVersion = (byte)(payload[0] >> 4 & 0xF);
        handoverRequestRecord.setMinorVersion(minorVersion);
        handoverRequestRecord.setMajorVersion(majorVersion);
        List<Record> records = messageDecoder.decodeToRecords(payload, 1, payload.length - 1);
        if (records.isEmpty()) {
            throw new IllegalArgumentException("Expected collision resolution record and at least one alternative carrier");
        }
        for (int i = 0; i < records.size(); ++i) {
            Record record = records.get(i);
            if (record instanceof CollisionResolutionRecord) {
                handoverRequestRecord.setCollisionResolution((CollisionResolutionRecord)record);
                continue;
            }
            if (!(record instanceof AlternativeCarrierRecord)) continue;
            handoverRequestRecord.add((AlternativeCarrierRecord)records.get(i));
        }
        if (handoverRequestRecord.getAlternativeCarriers().size() == 0) {
            throw new IllegalArgumentException("Expected at least one alternative carrier");
        }
        return handoverRequestRecord;
    }
}

