/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.handover.decoder;

import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.handover.records.ErrorRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class ErrorRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        Number number;
        ErrorRecord errorRecord = new ErrorRecord();
        ErrorRecord.ErrorReason errorReason = ErrorRecord.ErrorReason.toErrorReason(payload[0]);
        errorRecord.setErrorReason(errorReason);
        switch (errorReason) {
            case TemporaryMemoryConstraints: {
                number = new Short((short)(payload[1] & 0xFFFF));
                break;
            }
            case PermanenteMemoryConstraints: {
                number = new Long(((long)(payload[1] & 0xFF) << 24) + (long)((payload[2] & 0xFF) << 16) + (long)((payload[3] & 0xFF) << 8) + (long)((payload[4] & 0xFF) << 0));
                break;
            }
            case CarrierSpecificConstraints: {
                number = new Short((short)(payload[1] & 0xFFFF));
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        errorRecord.setErrorData(number);
        return errorRecord;
    }
}

