/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.encoder;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Locale;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.records.TextRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class TextRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        byte status;
        TextRecord textRecord = (TextRecord)wellKnownRecord;
        if (!textRecord.hasLocale()) {
            throw new NdefEncoderException("Expected locale", wellKnownRecord);
        }
        if (!textRecord.hasEncoding()) {
            throw new NdefEncoderException("Expected encoding", wellKnownRecord);
        }
        if (!textRecord.hasText()) {
            throw new NdefEncoderException("Expected text", wellKnownRecord);
        }
        Locale locale = textRecord.getLocale();
        byte[] languageData = (locale.getLanguage() + (locale.getCountry() == null || locale.getCountry().length() == 0 ? "" : "-" + locale.getCountry())).getBytes();
        if (languageData.length > 31) {
            throw new NdefEncoderException("language code length longer than 2^5. this is not supported.", wellKnownRecord);
        }
        Charset encoding = textRecord.getEncoding();
        byte[] textData = this.getTextAsBytes(textRecord, encoding);
        byte[] payload = new byte[1 + languageData.length + textData.length];
        payload[0] = status = (byte)(languageData.length | (TextRecord.UTF16.equals(encoding) ? 128 : 0));
        System.arraycopy(languageData, 0, payload, 1, languageData.length);
        System.arraycopy(textData, 0, payload, 1 + languageData.length, textData.length);
        return payload;
    }

    private byte[] getTextAsBytes(TextRecord textRecord, Charset encoding) {
        try {
            return textRecord.getText().getBytes(encoding.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

