/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadEncoder;
import org.nfctools.ndef.wkt.records.SignatureRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class SignatureRecordEncoder
implements WellKnownRecordPayloadEncoder {
    @Override
    public byte[] encodePayload(WellKnownRecord wellKnownRecord, NdefMessageEncoder messageEncoder) {
        SignatureRecord myRecord = (SignatureRecord)wellKnownRecord;
        return this.createPayload(messageEncoder, myRecord);
    }

    private byte[] createPayload(NdefMessageEncoder messageEncoder, SignatureRecord signatureRecord) {
        if (signatureRecord.isStartMarker()) {
            return new byte[]{1, 0};
        }
        try {
            byte[] signatureOrUri;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(signatureRecord.getVersion());
            if (!signatureRecord.hasSignatureType()) {
                throw new NdefEncoderException("Expected signature type", signatureRecord);
            }
            if (signatureRecord.hasSignature() && signatureRecord.hasSignatureUri()) {
                throw new NdefEncoderException("Expected signature or signature uri, not both", signatureRecord);
            }
            if (!signatureRecord.hasSignature() && !signatureRecord.hasSignatureUri()) {
                throw new NdefEncoderException("Expected signature or signature uri", signatureRecord);
            }
            baos.write((signatureRecord.hasSignatureUri() ? 1 : 0) << 7 | signatureRecord.getSignatureType().getValue() & 0x7F);
            if (signatureRecord.hasSignature()) {
                signatureOrUri = signatureRecord.getSignature();
                if (signatureOrUri.length > 65535) {
                    throw new NdefEncoderException("Expected signature size " + signatureOrUri.length + " <= 65535", signatureRecord);
                }
            } else {
                signatureOrUri = signatureRecord.getSignatureUri().getBytes(NdefConstants.UTF_8_CHARSET);
                if (signatureOrUri.length > 65535) {
                    throw new NdefEncoderException("Expected signature uri byte size " + signatureOrUri.length + " <= 65535", signatureRecord);
                }
            }
            baos.write(signatureOrUri.length >> 8 & 0xFF);
            baos.write(signatureOrUri.length & 0xFF);
            baos.write(signatureOrUri);
            if (!signatureRecord.hasCertificateFormat()) {
                throw new NdefEncoderException("Expected certificate format", signatureRecord);
            }
            List<byte[]> certificates = signatureRecord.getCertificates();
            if (certificates.size() > 16) {
                throw new NdefEncoderException("Expected number of certificates " + certificates.size() + " <= 15", signatureRecord);
            }
            SignatureRecord.CertificateFormat certificateFormat = signatureRecord.getCertificateFormat();
            baos.write((signatureRecord.hasCertificateUri() ? 1 : 0) << 7 | certificateFormat.getValue() << 4 | certificates.size() & 0xF);
            for (int i = 0; i < certificates.size(); ++i) {
                byte[] certificate = certificates.get(i);
                if (certificate.length > 65535) {
                    throw new NdefEncoderException("Expected certificate " + i + " size " + certificate.length + " <= 65535", signatureRecord);
                }
                baos.write(certificate.length >> 8 & 0xFF);
                baos.write(certificate.length & 0xFF);
                baos.write(certificate);
            }
            if (signatureRecord.hasCertificateUri()) {
                byte[] certificateUri = signatureRecord.getCertificateUri().getBytes(NdefConstants.UTF_8_CHARSET);
                if (certificateUri.length > 65535) {
                    throw new NdefEncoderException("Expected certificate uri byte size " + certificateUri.length + " <= 65535", signatureRecord);
                }
                baos.write(certificateUri.length >> 8 & 0xFF);
                baos.write(certificateUri.length & 0xFF);
                baos.write(certificateUri);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

