/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt.decoder;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.nfctools.ndef.NdefConstants;
import org.nfctools.ndef.NdefMessageDecoder;
import org.nfctools.ndef.RecordUtils;
import org.nfctools.ndef.wkt.WellKnownRecordPayloadDecoder;
import org.nfctools.ndef.wkt.records.SignatureRecord;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class SignatureRecordDecoder
implements WellKnownRecordPayloadDecoder {
    @Override
    public WellKnownRecord decodePayload(byte[] payload, NdefMessageDecoder messageDecoder) {
        SignatureRecord signatureRecord = new SignatureRecord();
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(payload);
            int version = bais.read();
            signatureRecord.setVersion((byte)version);
            int header = bais.read();
            boolean signatureUriPresent = (header & 0x80) != 0;
            SignatureRecord.SignatureType type = SignatureRecord.SignatureType.toSignatureType(header & 0x7F);
            signatureRecord.setSignatureType(type);
            if (signatureUriPresent || type != SignatureRecord.SignatureType.NOT_PRESENT) {
                int size = RecordUtils.readUnsignedShort(bais);
                if (size > 0) {
                    byte[] signatureOrUri = RecordUtils.readByteArray(bais, size);
                    if (signatureUriPresent) {
                        signatureRecord.setSignatureUri(new String(signatureOrUri, NdefConstants.UTF_8_CHARSET));
                    } else {
                        signatureRecord.setSignature(signatureOrUri);
                    }
                }
                int certificateHeader = bais.read();
                signatureRecord.setCertificateFormat(SignatureRecord.CertificateFormat.toCertificateFormat(certificateHeader >> 4 & 7));
                int numberOfCertificates = certificateHeader & 0xF;
                for (int i = 0; i < numberOfCertificates; ++i) {
                    int certificateSize = RecordUtils.readUnsignedShort(bais);
                    byte[] certificate = RecordUtils.readByteArray(bais, certificateSize);
                    signatureRecord.add(certificate);
                }
                if ((certificateHeader & 0x80) != 0) {
                    int certificateUriSize = RecordUtils.readUnsignedShort(bais);
                    byte[] certificateUri = RecordUtils.readByteArray(bais, certificateUriSize);
                    signatureRecord.setCertificateUri(new String(certificateUri, NdefConstants.UTF_8_CHARSET));
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to decode", e);
        }
        return signatureRecord;
    }
}

