/*
 * Decompiled with CFR 0.152.
 */
package org.nfctools.ndef.wkt;

import java.util.HashMap;
import java.util.Map;
import org.nfctools.ndef.NdefEncoderException;
import org.nfctools.ndef.NdefMessageEncoder;
import org.nfctools.ndef.NdefRecord;
import org.nfctools.ndef.Record;
import org.nfctools.ndef.wkt.WellKnownRecordConfig;
import org.nfctools.ndef.wkt.encoder.RecordEncoder;
import org.nfctools.ndef.wkt.records.WellKnownRecord;

public class WellKnownRecordEncoder
implements RecordEncoder {
    private Map<Class<?>, WellKnownRecordConfig> knownRecordTypes = new HashMap();

    @Override
    public boolean canEncode(Record record) {
        return this.knownRecordTypes.containsKey(record.getClass());
    }

    @Override
    public NdefRecord encodeRecord(Record record, NdefMessageEncoder messageEncoder) {
        byte[] key = record.getId();
        if (key != null && key.length > 255) {
            throw new NdefEncoderException("Expected record id length <= 255 bytes", record);
        }
        WellKnownRecordConfig config = this.knownRecordTypes.get(record.getClass());
        byte[] payload = config.getPayloadEncoder().encodePayload((WellKnownRecord)record, messageEncoder);
        byte[] type = config.getRecordType().getType();
        return new NdefRecord(1, type, key, payload);
    }

    public void addRecordConfig(WellKnownRecordConfig config) {
        this.knownRecordTypes.put(config.getRecordClass(), config);
    }
}

